/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.component;

import com.sap.ip.me.mdk.api.awt.gui.component.ComboBox;
import com.sap.ip.me.mdk.api.awt.gui.component.InputField;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;

public class ComponentConstants {
    public static Color menuBarBGColor = new Color(Integer.parseInt("909CAE", 16));
    public static Color menuBarTextColor = new Color(Integer.parseInt("006600", 16));
    public static Color menuBodyBGColor = new Color(Integer.parseInt("EFF6FB", 16));
    public static Color tableHeaderBGColor = new Color(Integer.parseInt("DCE3EC", 16));
    public static Color headerBodyBGColor = new Color(Integer.parseInt("CDDEE9", 16));
    public static Color headerTextColor = new Color(Integer.parseInt("006600", 16));
    public static Color labelTextColor = new Color(Integer.parseInt("666666", 16));
    public static Color lightYellowColor = new Color(Integer.parseInt("FFFBD5", 16));
    public static Color linkTextColor = new Color(Integer.parseInt("FF9900", 16));
    public static Color linkHeaderColor = new Color(Integer.parseInt("B96F00", 16));
    public static Font fntBold11Dialog = new Font("Dialog", 1, 11);
    public static Font fntBold10Dialog = new Font("Dialog", 1, 10);
    public static Font fntPlain10Dialog = new Font("Dialog", 0, 10);
    public static Font fntPlain9Dialog = new Font("Dialog", 0, 9);
    public static String imageFolder = "images";
    public static final String iconLogo = "milogo.gif";
    public static final String iconPlay = "run.gif";
    public static final String iconNew = "nnew.gif";
    public static final String iconCarList = "ncustlist.gif";
    public static final String iconTopPage = "top.gif";
    public static final String iconPrevPage = "pageup.gif";
    public static final String iconNextPage = "pagedown.gif";
    public static final String iconLastPage = "bottom.gif";
    public static final String iconTopPageOff = "top_off.gif";
    public static final String iconPrevPageOff = "pageup_off.gif";
    public static final String iconNextPageOff = "pagedown_off.gif";
    public static final String iconLastPageOff = "bottom_off.gif";
    public static final String iconLastRec = "end.gif";
    public static final String iconNextRec = "next.gif";
    public static final String iconPrevRec = "prev.gif";
    public static final String iconFirstRec = "start.gif";
    public static final String iconLastRecOff = "endd.gif";
    public static final String iconNextRecOff = "nextd.gif";
    public static final String iconPrevRecOff = "prevd.gif";
    public static final String iconFirstRecOff = "startd.gif";
    public static final String iconSave = "nsave.gif";
    public static final String iconCancel = "ncancel.gif";
    public static final String iconDSave = "dsave.gif";
    public static final String iconDelete = "ntrash.gif";
    public static final String iconBackToTop = "jgtop.gif";
    public static String appDir = ComponentConstants.getAppPath();
    private static String imageDir = appDir + File.separatorChar + imageFolder;

    private static String getAppPath() {
        File f = new File("");
        return f.getAbsolutePath();
    }

    public static void setImageFolder(String imgFolder) {
        imageFolder = imgFolder;
    }

    public static final Color createColor(String str) {
        return new Color(Integer.parseInt(str, 16));
    }

    public static final Image getImage(String image) {
        Image img = null;
        String pIcon = imageFolder + "/" + image;
        URL url = ClassLoader.getSystemResource(pIcon);
        if (url != null) {
            img = Toolkit.getDefaultToolkit().getImage(url);
        }
        return img;
    }

    public static final int pixelsWideForString(String str, FontMetrics fm) {
        return fm.stringWidth(str);
    }

    public static final int pixelsHighForString(String str, FontMetrics fm) {
        int height = fm.getHeight() + fm.getAscent() + fm.getDescent();
        return height * str.length();
    }

    public static InputField createTextField(int width, int maxChar, boolean isNumber) {
        InputField tf = new InputField(width, maxChar);
        tf.setFont(fntPlain9Dialog);
        if (isNumber) {
            tf.setAsNumberField();
        }
        return tf;
    }

    public static ComboBox createChoice(String[] list, String[] data, String selectedString) {
        ComboBox ch = new ComboBox();
        ch.setFont(fntPlain9Dialog);
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                if (data == null) {
                    ch.addItem(list[i]);
                } else {
                    ch.addItem(list[i], data[i]);
                }
                ++i;
            }
            ch.select(selectedString);
        }
        return ch;
    }

    public static Checkbox createCheckBox(String label, String name) {
        Checkbox cb = new Checkbox(label);
        cb.setFont(fntPlain9Dialog);
        cb.setBackground(menuBodyBGColor);
        cb.setName(name);
        return cb;
    }

    public static LinkButton createImageButton(Image img, String targetPage, String handlerName) {
        LinkButton imgButton = new LinkButton(img);
        imgButton.setTargetPage(targetPage);
        imgButton.setTargetHandler(handlerName);
        return imgButton;
    }

    public static LinkButton createTextButton(String text, String targetPage, String handlerName) {
        LinkButton imgButton = new LinkButton(text);
        imgButton.setTargetPage(targetPage);
        imgButton.setTargetHandler(handlerName);
        return imgButton;
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }
}

