/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.ui;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import pios.emulator.PEmulator;

public class PResourceBundle {
    private ResourceBundle resourceBundle = null;

    public PResourceBundle(String string) {
        try {
            this.resourceBundle = ResourceBundle.getBundle(string, Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            PEmulator.getLog().appendWarning("Error getting the default locale (" + Locale.getDefault().getDisplayName() + ") for " + string + ". The english default will be used.");
            try {
                this.resourceBundle = ResourceBundle.getBundle(string, Locale.US);
            }
            catch (MissingResourceException missingResourceException2) {
                PEmulator.getLog().appendMessage("No language resource file was found for base name: " + string);
            }
        }
    }

    public String getString(String string) {
        try {
            return this.resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            PEmulator.getLog().appendWarning("Resource " + string + " was not found in the resource file.");
            return "";
        }
    }

    public String getString(String string, Object[] objectArray) {
        try {
            String string2 = this.resourceBundle.getString(string);
            int n = 0;
            while (n < objectArray.length) {
                String string3 = "[" + n + "]";
                while (string2.indexOf(string3) != -1) {
                    String string4 = string2.substring(0, string2.indexOf(string3));
                    string4 = string4 + objectArray[n].toString();
                    string2 = string4 = string4 + string2.substring(string2.indexOf(string3) + string3.length());
                }
                ++n;
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            PEmulator.getLog().appendWarning("Resource " + string + " was not found in the resource file.");
            return "";
        }
    }
}

