/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.ui;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;

public class PFileFilter
extends FileFilter {
    private Hashtable filters = new Hashtable();
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public PFileFilter() {
    }

    public PFileFilter(String string) {
        this(string, null);
    }

    public PFileFilter(String string, String string2) {
        this();
        if (string != null) {
            this.addExtension(string);
        }
        if (string2 != null) {
            this.setDescription(string2);
        }
    }

    public PFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public PFileFilter(String[] stringArray, String string) {
        this();
        int n = 0;
        while (n < stringArray.length) {
            this.addExtension(stringArray[n]);
            ++n;
        }
        if (string != null) {
            this.setDescription(string);
        }
    }

    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.filters.get(this.getExtension(file)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String string) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(string.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Enumeration enumeration = this.filters.keys();
                if (enumeration != null) {
                    this.fullDescription = this.fullDescription + "." + (String)enumeration.nextElement();
                    while (enumeration.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", " + (String)enumeration.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

