/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.ui;

import pios.emulator.ui.BinaryDataEntryTable;

public class BinaryTableCharacter {
    private int value = 0;

    public BinaryTableCharacter() {
    }

    public BinaryTableCharacter(int n) {
        this.value = n;
    }

    public int getValue() {
        return this.value;
    }

    public char getValueAsChar() {
        if (this.value == 0) {
            return ' ';
        }
        if (this.value < 32 || this.value > 126) {
            return '?';
        }
        return (char)this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public String toString() {
        if (BinaryDataEntryTable.getDataEntryType() == 0) {
            return String.valueOf(this.value);
        }
        if (BinaryDataEntryTable.getDataEntryType() == 1) {
            if (this.value == 0) {
                return " ";
            }
            if (this.value < 32 || this.value > 126) {
                return "?";
            }
            return new Character((char)this.value).toString();
        }
        String string = Integer.toHexString(this.value & 0xFF).toUpperCase();
        return string.length() == 2 ? string : "0" + string;
    }
}

