/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.ui;

import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import pios.emulator.ui.BinaryTableCharacter;

public class BinaryDataEntryTable
extends JTable {
    public static final int BINARY = 0;
    public static final int ASCII = 1;
    public static final int HEXADECIMAL = 2;
    private static final int BACKSPACE = 8;
    private static final int ENTER = 10;
    private static final int DELETE = 127;
    private int columnCount = 0;
    private static int entryType = 1;
    private JButton defaultButton = null;

    public BinaryDataEntryTable(TableModel tableModel, int n, JButton jButton) {
        super(tableModel);
        this.columnCount = tableModel.getColumnCount();
        entryType = n;
        this.defaultButton = jButton;
        super.setGridColor(Color.black);
        super.setSelectionBackground(Color.white);
        super.setSelectionForeground(Color.black);
        super.setAutoResizeMode(0);
        super.getTableHeader().setReorderingAllowed(false);
        super.getTableHeader().setResizingAllowed(false);
        int n2 = 0;
        while (n2 < this.columnCount) {
            super.getColumnModel().getColumn(n2).setPreferredWidth(new JLabel((String)"00000").getPreferredSize().width);
            ++n2;
        }
        super.setRowHeight(0, (int)super.getTableHeader().getPreferredSize().getHeight());
        super.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                BinaryDataEntryTable.this.changeCell(keyEvent.getKeyChar());
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    BinaryDataEntryTable.this.deleteCell();
                }
            }
        });
    }

    public void setDataEntryType(int n) {
        entryType = n;
        super.updateUI();
    }

    public static int getDataEntryType() {
        return entryType;
    }

    private void changeCell(char c) {
        BinaryTableCharacter binaryTableCharacter = (BinaryTableCharacter)super.getValueAt(0, super.getSelectedColumn());
        if (c == '\b') {
            if (entryType == 1) {
                binaryTableCharacter.setValue(0);
                this.moveToPreviousColumn();
            } else if (entryType == 0) {
                if (binaryTableCharacter.getValue() == 0) {
                    this.moveToPreviousColumn();
                } else {
                    String string = String.valueOf(binaryTableCharacter.getValue());
                    if (string.length() == 1) {
                        binaryTableCharacter.setValue(0);
                    } else {
                        String string2 = string.substring(0, string.length() - 1);
                        binaryTableCharacter.setValue(new Integer(string2));
                    }
                }
            } else if (binaryTableCharacter.getValue() == 0) {
                this.moveToPreviousColumn();
            } else {
                String string = Integer.toHexString(binaryTableCharacter.getValue() & 0xFF).toUpperCase();
                if (string.length() == 1) {
                    binaryTableCharacter.setValue(0);
                } else {
                    String string3 = string.substring(0, string.length() - 1);
                    binaryTableCharacter.setValue(Integer.parseInt(string3, 16));
                }
            }
        } else if (c == '\n') {
            this.defaultButton.doClick();
        } else if (entryType == 1) {
            binaryTableCharacter.setValue(c);
            this.moveToNextColumn();
        } else if (entryType == 0) {
            if (c >= '0' && c <= '9') {
                String string = String.valueOf(c);
                if (binaryTableCharacter.getValue() != 0) {
                    String string4 = String.valueOf(binaryTableCharacter.getValue());
                    string = string4.length() < 3 ? string4 + string : string4;
                }
                if (new Integer(string) <= 255) {
                    binaryTableCharacter.setValue(new Integer(string));
                    if (string.length() == 3) {
                        this.moveToNextColumn();
                    }
                }
            }
        } else if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') {
            String string = String.valueOf(c);
            if (binaryTableCharacter.getValue() != 0) {
                String string5 = Integer.toHexString(binaryTableCharacter.getValue() & 0xFF).toUpperCase();
                string = string5.length() < 2 ? string5 + string : string5;
            }
            binaryTableCharacter.setValue(Integer.parseInt(string, 16));
            if (string.length() == 2) {
                this.moveToNextColumn();
            }
        }
        super.updateUI();
    }

    private void deleteCell() {
        ((BinaryTableCharacter)super.getValueAt(0, super.getSelectedColumn())).setValue(0);
        super.updateUI();
    }

    private void moveToPreviousColumn() {
        if (super.getSelectedColumn() > 0) {
            super.changeSelection(0, super.getSelectedColumn() - 1, false, false);
        }
    }

    private void moveToNextColumn() {
        if (super.getSelectedColumn() + 1 < this.columnCount) {
            super.changeSelection(0, super.getSelectedColumn() + 1, false, false);
        }
    }
}

