/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import pios.emulator.PDialog;
import pios.emulator.PEmulator;
import pios.emulator.PEmulatorException;
import pios.emulator.PProject;

public class SaveProjectAction
extends AbstractAction {
    public SaveProjectAction() {
        super(PEmulator.getResourceBundle().getString("MAIN_OPTION_SAVE_PROJECT"), PEmulator.getImageIcon(PEmulator.getResourceBundle().getString("IMAGE.SAVE_PROJECT")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PEmulator.getMainFrame().setStatusMessage("", false);
        PEmulator.getLog().appendMessage("Save Project action called...");
        PProject pProject = PEmulator.getProjectManager().getActiveProject();
        if (pProject.isNew()) {
            PEmulator.getLog().appendMessage("New Project found.  Calling the Save As action...");
            PEmulator.getMainFrame().getSaveAsAction().actionPerformed(actionEvent);
            return;
        }
        PEmulator.getLog().appendMessage("Saving the project...");
        try {
            PEmulator.getProjectManager().saveProject();
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_PROJECT_SAVED"), false);
            PEmulator.getLog().appendMessage("Project saved successfully.");
        }
        catch (PEmulatorException pEmulatorException) {
            PDialog.errorDialog(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_SAVING_LAST_PROJECT"));
            PEmulator.getLog().appendError("Error saving project", pEmulatorException);
        }
    }
}

