/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import pios.emulator.PDialog;
import pios.emulator.PEmulator;
import pios.emulator.PEmulatorException;
import pios.emulator.actions.IOAction;
import pios.emulator.ui.ProjectFileFilter;

public class SaveAsProjectAction
extends IOAction {
    public SaveAsProjectAction() {
        super(PEmulator.getResourceBundle().getString("MAIN_OPTION_SAVE_PROJECT_AS"), PEmulator.getImageIcon(PEmulator.getResourceBundle().getString("IMAGE.SAVE_PROJECT_AS")), new ProjectFileFilter());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PEmulator.getMainFrame().setStatusMessage("", false);
        PEmulator.getLog().appendMessage("Save Project As action called...");
        File file = super.save(PEmulator.getResourceBundle().getString("DIALOG_MSG_SAVE_PROJECT_HEADER"));
        if (file == null) {
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_SAVE_PROJECT_ABORTED"), false);
            PEmulator.getLog().appendMessage("Save as project action aborted.");
            return;
        }
        if (!file.getName().endsWith(".ppj")) {
            PEmulator.getLog().appendWarning("Adding extension to the filename...");
            File file2 = new File(file.getAbsolutePath() + ".ppj");
            file.renameTo(file2);
            file = file2;
        }
        if (file.exists() && PDialog.yesNoDialog(PEmulator.getResourceBundle().getString("DIALOG_MSG_SAVE_PROJECT_CONFIRM_REPLACE"), PEmulator.getResourceBundle().getString("DIALOG_MSG_SAVE_PROJECT_HEADER")) == 1) {
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_SAVE_PROJECT_ABORTED"), false);
            PEmulator.getLog().appendMessage("Save canceled...");
            return;
        }
        PEmulator.getLog().appendMessage("Saving the project...");
        try {
            PEmulator.getProjectManager().saveProject(file);
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_PROJECT_SAVED"), false);
            PEmulator.getLog().appendMessage("Saved project succesfully.");
        }
        catch (PEmulatorException pEmulatorException) {
            PDialog.errorDialog(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_SAVING_PROJECT", new Object[]{file.getAbsolutePath()}));
            PEmulator.getLog().appendError("Error saving project: " + file.getAbsolutePath(), pEmulatorException);
        }
    }
}

