/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import pios.emulator.PDialog;
import pios.emulator.PEmulator;
import pios.emulator.PEmulatorException;
import pios.emulator.PProjectManager;
import pios.emulator.PendingChangesDialog;
import pios.emulator.actions.IOAction;
import pios.emulator.ui.ProjectFileFilter;

public class OpenProjectAction
extends IOAction {
    private static String defaultPath = PEmulator.getPaths().getProjectsDir();

    public OpenProjectAction() {
        super(PEmulator.getResourceBundle().getString("MAIN_OPTION_OPEN_PROJECT"), PEmulator.getImageIcon(PEmulator.getResourceBundle().getString("IMAGE.OPEN_PROJECT")), new ProjectFileFilter());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        PEmulator.getMainFrame().setStatusMessage("", false);
        PEmulator.getLog().appendMessage("Open Project action called...");
        if (!PendingChangesDialog.loosePendingPeripheralChanges()) {
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_OPEN_PROJECT_ABORTED"), false);
            PEmulator.getLog().appendMessage("Open Project action aborted...");
            return;
        }
        PProjectManager pProjectManager = PEmulator.getProjectManager();
        if (pProjectManager.isProjectUpdated()) {
            int n = PDialog.yesNoCancelDialog(PEmulator.getResourceBundle().getString("DIALOG_MSG_SAVE_PROJECT"), PEmulator.getResourceBundle().getString("DIALOG_MSG_SAVE_PROJECT_HEADER"));
            if (n == 2 || n == -1) {
                PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_OPEN_PROJECT_ABORTED"), false);
                PEmulator.getLog().appendMessage("Open Project action aborted...");
                return;
            }
            if (n == 0) {
                PEmulator.getMainFrame().getSaveProjectAction().actionPerformed(actionEvent);
            }
        }
        if ((file = super.select(defaultPath, PEmulator.getResourceBundle().getString("DIALOG_MSG_OPEN_PROJECT_HEADER"))) == null) {
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_OPEN_PROJECT_ABORTED"), false);
            PEmulator.getLog().appendMessage("Open Project action aborted...");
            return;
        }
        try {
            pProjectManager.openProject(file);
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_PROJECT_OPENED"), false);
            PEmulator.getLog().appendMessage("Proyect opened succesfully.");
            defaultPath = file.getParentFile().getAbsolutePath();
        }
        catch (PEmulatorException pEmulatorException) {
            PDialog.errorDialog(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_OPENING_PROJECT", new Object[]{file.getAbsolutePath()}));
            PEmulator.getLog().appendError("Error opening project: " + file.getAbsolutePath(), pEmulatorException);
        }
    }
}

