/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import pios.emulator.PDialog;
import pios.emulator.PEmulator;
import pios.emulator.PProjectManager;
import pios.emulator.PendingChangesDialog;

public class NewProjectAction
extends AbstractAction {
    public NewProjectAction() {
        super(PEmulator.getResourceBundle().getString("MAIN_OPTION_NEW_PROJECT"), PEmulator.getImageIcon(PEmulator.getResourceBundle().getString("IMAGE.NEW_PROJECT")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PEmulator.getMainFrame().setStatusMessage("", false);
        PEmulator.getLog().appendMessage("New Project action called...");
        if (!PendingChangesDialog.loosePendingPeripheralChanges()) {
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_NEW_PROJECT_ABORTED"), false);
            PEmulator.getLog().appendMessage("New Project action aborted...");
            return;
        }
        PProjectManager pProjectManager = PEmulator.getProjectManager();
        if (pProjectManager.isProjectUpdated()) {
            int n = PDialog.yesNoCancelDialog(PEmulator.getResourceBundle().getString("DIALOG_MSG_SAVE_PROJECT"), PEmulator.getResourceBundle().getString("DIALOG_MSG_SAVE_PROJECT_HEADER"));
            if (n == -1 || n == 2) {
                PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_NEW_PROJECT_ABORTED"), false);
                PEmulator.getLog().appendMessage("New Project action aborted...");
                return;
            }
            if (n == 0) {
                if (PEmulator.getMainFrame().getSaveProjectAction().isEnabled()) {
                    PEmulator.getMainFrame().getSaveProjectAction().actionPerformed(actionEvent);
                } else {
                    PEmulator.getMainFrame().getSaveAsAction().actionPerformed(actionEvent);
                }
            }
        }
        pProjectManager.newProject();
        PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_NEW_PROJECT_CREATED"), false);
        PEmulator.getLog().appendMessage("New Project created successfully.");
    }
}

