/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import pios.emulator.PDialog;
import pios.emulator.PEmulator;
import pios.emulator.actions.IOAction;
import pios.emulator.ui.ReqFileFilter;

public class ImportReqAction
extends IOAction {
    private static String defaultPath = PEmulator.getPaths().getRoot();

    public ImportReqAction() {
        super(PEmulator.getResourceBundle().getString("MAIN_OPTION_IMPORT_REQUIREMENTS"), PEmulator.getImageIcon(PEmulator.getResourceBundle().getString("IMAGE.IMPORT_REQUIREMENTS_DOCUMENT")), new ReqFileFilter());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PEmulator.getMainFrame().setStatusMessage("", false);
        File file = super.importFile(defaultPath, PEmulator.getResourceBundle().getString("DIALOG_MSG_IMPORT_REQUIREMENTS_HEADER"));
        if (file == null) {
            return;
        }
        try {
            PEmulator.loadDriverRequirementsDocument(file);
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_REQUIREMENTS_IMPORTED"), false);
            PEmulator.getLog().appendMessage("Requirements imported successfully.");
            defaultPath = file.getParentFile().getAbsolutePath();
        }
        catch (Exception exception) {
            PDialog.errorDialog(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_IMPORTING_REQUIREMENTS"));
            PEmulator.getLog().appendError("Error importing Requirements Document.", exception);
        }
    }
}

