/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import pios.emulator.PDialog;
import pios.emulator.PEmulator;
import pios.emulator.api.IPData;
import pios.emulator.api.IPPeripheral;

public class DeleteDataAction
extends AbstractAction {
    public DeleteDataAction() {
        super(PEmulator.getResourceBundle().getString("MAIN_OPTION_DELETE_DATA"), PEmulator.getImageIcon(PEmulator.getResourceBundle().getString("IMAGE.DELETE_DATA")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        PEmulator.getMainFrame().setStatusMessage("", false);
        PEmulator.getLog().appendMessage("Delete data action called...");
        IPPeripheral iPPeripheral = PEmulator.getActivePeripheral();
        IPData iPData = iPPeripheral.getDataHandler().getActiveData();
        boolean bl = false;
        if (PEmulator.getActivePeripheral().hasPendingChanges()) {
            n = PDialog.yesNoDialog(PEmulator.getResourceBundle().getString("DIALOG_MSG_LOOSE_PERF_UNSAVED_CHANGES", new Object[]{iPPeripheral.getName(), iPData.getName()}), PEmulator.getResourceBundle().getString("DIALOG_MSG_LOOSE_PERF_UNSAVED_CHANGES_HEADER"));
            if (n != 0) {
                PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_DELETE_DATA_ABORTED"), false);
                return;
            }
            bl = true;
        }
        if ((n = PDialog.yesNoDialog(PEmulator.getResourceBundle().getString("DIALOG_MSG_CONFIRM_DELETE", new Object[]{iPData.getName()}), PEmulator.getResourceBundle().getString("DIALOG_MSG_CONFIRM_DELETE_HEADER"))) != 0) {
            if (bl) {
                iPPeripheral.getDataHandler().setActiveData(null);
                iPPeripheral.getDataHandler().setActiveData(iPData);
            }
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_DELETE_DATA_ABORTED"), false);
            return;
        }
        IPData iPData2 = PEmulator.getActivePeripheral().getDataHandler().getActiveData();
        PEmulator.getActivePeripheral().getDataHandler().getDataSet().remove(iPData2);
        PEmulator.getActivePeripheral().getDataHandler().setActiveData(null);
        PEmulator.getMainFrame().removeSelectedDataFromTree();
        PEmulator.getLog().appendMessage("Deleting data entry from the project...");
        PEmulator.getProjectManager().setProjectUpdated();
        PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_DATA_DELETED", new Object[]{iPData2.getName()}), false);
    }
}

