/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator;

import java.io.File;
import java.util.Enumeration;
import pios.emulator.PEmuProps;
import pios.emulator.PEmulator;
import pios.emulator.PEmulatorException;
import pios.emulator.PProject;
import pios.emulator.api.IPPeripheral;

public class PProjectManager {
    private PProject activeProject = null;
    private boolean projectUpdated = false;

    public PProject getActiveProject() {
        return this.activeProject;
    }

    public void openProject(File file) throws PEmulatorException {
        PEmulator.getLog().appendMessage("Loading project from file " + file.getName() + "...");
        this.activeProject = new PProject(file);
        this.projectUpdated = false;
        PEmulator.getMainFrame().loadProjectIntoTree(this.activeProject);
    }

    public boolean openLastProject() throws PEmulatorException {
        String string = PEmuProps.getInstance().getLastOpenProject();
        if (string != null && !string.equals("")) {
            if (new File(string).exists()) {
                this.openProject(new File(string));
                return true;
            }
            throw new PEmulatorException("The last opened project: " + string + " was not found.");
        }
        return false;
    }

    public void saveProject() throws PEmulatorException {
        this.activeProject.save();
        this.projectUpdated = false;
    }

    public void saveProject(File file) throws PEmulatorException {
        this.activeProject.save(file);
        this.projectUpdated = false;
        PEmulator.getMainFrame().refreshTree(this.activeProject);
    }

    public void newProject() {
        Enumeration enumeration = PEmulator.getPeripherals();
        while (enumeration.hasMoreElements()) {
            ((IPPeripheral)enumeration.nextElement()).getDataHandler().setActiveData(null);
        }
        this.activeProject = new PProject();
        this.projectUpdated = false;
        PEmulator.getMainFrame().loadProjectIntoTree(this.activeProject);
    }

    public void setProjectUpdated() {
        this.projectUpdated = true;
    }

    public boolean isProjectUpdated() {
        return this.projectUpdated;
    }
}

