/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import pios.emulator.PDialog;
import pios.emulator.PEmulator;
import pios.emulator.PEmulatorException;
import pios.emulator.api.IPDataSet;
import pios.emulator.api.IPPeripheral;

public class PProject {
    public static final String PROJECT_EXTENSION = ".ppj";
    private File file = null;

    public PProject() {
        PEmulator.getMainFrame().getSaveProjectAction().setEnabled(true);
        Enumeration enumeration = PEmulator.getPeripherals();
        while (enumeration.hasMoreElements()) {
            IPDataSet iPDataSet = ((IPPeripheral)enumeration.nextElement()).getDataHandler().getDataSet();
            if (iPDataSet == null) continue;
            iPDataSet.clear();
        }
    }

    public PProject(File file) throws PEmulatorException {
        this.file = file;
        PEmulator.getLog().appendMessage("Loading project from " + file.getName() + "...");
        DOMParser dOMParser = new DOMParser();
        Document document = null;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, "Unicode");
            InputSource inputSource = new InputSource(inputStreamReader);
            dOMParser.parse(inputSource);
            document = dOMParser.getDocument();
            PEmulator.getLog().appendMessage("Validating the document peripherals to make sure they are installed...");
            this.validatePeripherals(document);
            PEmulator.getLog().appendMessage("Getting the list of the projects peripherals...");
            Enumeration enumeration = PEmulator.getPeripherals();
            while (enumeration.hasMoreElements()) {
                IPPeripheral iPPeripheral = (IPPeripheral)enumeration.nextElement();
                iPPeripheral.getDataHandler().loadDataSet(document);
            }
        }
        catch (Exception exception) {
            throw new PEmulatorException("Error loading project: " + file.getAbsolutePath(), exception);
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (Exception exception) {}
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void save(File file) throws PEmulatorException {
        this.file = file;
        this.save();
    }

    /*
     * Loose catch block
     */
    protected void save() throws PEmulatorException {
        block12: {
            Object object;
            Object object2;
            PEmulator.getLog().appendMessage("Saving the project to " + this.file.getName() + "...");
            String string = "<?xml version=\"1.0\" encoding=\"UTF-16\"?>";
            string = string + "<project>";
            Enumeration enumeration = PEmulator.getPeripherals();
            while (enumeration.hasMoreElements()) {
                object2 = ((IPPeripheral)enumeration.nextElement()).getDataHandler().getDataSet();
                if (object2 == null || ((IPDataSet)object2).getDataList().size() <= 0) continue;
                object = ((IPDataSet)object2).save();
                string = string + (String)object;
            }
            string = string + "</project>";
            object2 = null;
            object = null;
            object2 = new FileOutputStream(this.file);
            object = new BufferedOutputStream((OutputStream)object2);
            ((FilterOutputStream)object).write(string.getBytes("UNICODE"));
            Object var7_5 = null;
            try {
                ((FilterOutputStream)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((FileOutputStream)object2).close();
            }
            catch (Exception exception) {}
            break block12;
            {
                catch (Exception exception) {
                    throw new PEmulatorException("Error saving project to: " + this.file.getName() + ".", exception);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    ((FilterOutputStream)object).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ((FileOutputStream)object2).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public boolean isNew() {
        return this.file == null;
    }

    public String getProjectLocation() {
        if (this.file == null) {
            return "";
        }
        return this.file.getPath();
    }

    public String toString() {
        if (this.file == null) {
            return PEmulator.getResourceBundle().getString("PROJECT.NEW_PROJECT");
        }
        return this.file.getName().substring(0, this.file.getName().length() - PROJECT_EXTENSION.length());
    }

    private void validatePeripherals(Document document) {
        NodeList nodeList = document.getElementsByTagName("project").item(0).getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            String string = nodeList.item(n).getNodeName();
            if (PEmulator.getPeripheral(string) == null) {
                PDialog.warningDialog(PEmulator.getResourceBundle().getString("PROJECT.MISSING_PERIPHERAL", new String[]{string}));
                PEmulator.getMainFrame().getSaveProjectAction().setEnabled(false);
            }
            ++n;
        }
    }
}

