/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import pios.emulator.PEmuProps;
import pios.emulator.PEmulatorException;
import pios.emulator.PPaths;
import pios.emulator.api.IPLog;

public class PLog
implements IPLog {
    public static final int INFO = 3;
    public static final int WARNING = 2;
    public static final int ERROR = 1;
    public static final int NONE = 0;
    private PrintStream log;
    private int traceLevel;
    private SimpleDateFormat dateFormater;

    protected PLog() throws Exception {
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        PrintStream printStream = null;
        try {
            fileOutputStream = new FileOutputStream(new PPaths().getRoot() + File.separator + "log.txt", true);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            printStream = new PrintStream(filterOutputStream);
        }
        catch (Exception exception) {
            try {
                printStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                filterOutputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception4) {
                // empty catch block
            }
            throw exception;
        }
        this.log = printStream;
        this.traceLevel = PEmuProps.getInstance().getTraceLevel();
        this.dateFormater = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        this.log.println("----------------------------------Log Started: " + this.dateFormater.format(new Date(System.currentTimeMillis())) + "----------------------------------");
        this.log.flush();
    }

    public void appendMessage(String string) {
        this.appendMessage(string, "Emulator");
    }

    void appendMessage(String string, String string2) {
        if (this.traceLevel >= 3) {
            this.print(string, "Message", string2);
        }
    }

    public void appendWarning(String string) {
        this.appendWarning(string, "Emulator");
    }

    protected void appendWarning(String string, String string2) {
        if (this.traceLevel >= 2) {
            this.print(string, "Warning", string2);
        }
    }

    public void appendError(String string) {
        this.appendError(string, "Emulator");
    }

    protected void appendError(String string, String string2) {
        if (this.traceLevel >= 1) {
            this.print(string, "Error  ", string2);
        }
    }

    public void appendError(String string, Throwable throwable) {
        this.appendError(string, throwable, "Emulator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendError(String string, Throwable throwable, String string2) {
        if (this.traceLevel >= 1) {
            StringBuffer stringBuffer = new StringBuffer();
            Throwable throwable2 = throwable;
            stringBuffer.append(System.getProperty("line.separator"));
            do {
                Exception exception2;
                Object var9_8;
                StringWriter stringWriter = null;
                PrintWriter printWriter = null;
                try {
                    stringWriter = new StringWriter();
                    printWriter = new PrintWriter(stringWriter);
                    throwable2.printStackTrace(printWriter);
                    printWriter.flush();
                    stringBuffer.append(stringWriter.toString());
                    var9_8 = null;
                }
                catch (Throwable throwable3) {
                    var9_8 = null;
                    try {
                        printWriter.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        stringWriter.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw throwable3;
                }
                try {
                    printWriter.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    stringWriter.close();
                }
                catch (Exception exception2) {}
            } while ((throwable2 = throwable2 instanceof PEmulatorException ? ((PEmulatorException)throwable2).getCause() : null) != null);
            this.print(string + stringBuffer.toString(), "Error  ", string2);
        }
    }

    public void close() {
        try {
            this.log.close();
        }
        catch (Exception exception) {}
    }

    private void print(String string, String string2, String string3) {
        this.log.println(this.dateFormater.format(new Date(System.currentTimeMillis())) + "  " + string2 + "  " + this.paddString(string3, 12) + "  " + string);
        this.log.flush();
    }

    private String paddString(String string, int n) {
        int n2 = string.length();
        while (n2 < n) {
            string = string + ' ';
            ++n2;
        }
        return string;
    }
}

