/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator;

import java.io.File;
import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import pios.emulator.MainFrame;
import pios.emulator.PDefinition;
import pios.emulator.PDialog;
import pios.emulator.PEmuProps;
import pios.emulator.PEmulatorException;
import pios.emulator.PLog;
import pios.emulator.PPaths;
import pios.emulator.PProject;
import pios.emulator.PProjectManager;
import pios.emulator.api.IPLog;
import pios.emulator.api.IPPeripheral;
import pios.emulator.req.DriverRequirementsDocument;
import pios.emulator.req.PeripheralRequirements;
import pios.emulator.rmi.EmulatorEmServer;
import pios.emulator.ui.PResourceBundle;

public class PEmulator {
    private static Vector peripherals = new Vector();
    private static IPPeripheral activePeripheral = null;
    private static IPLog log = null;
    private static PProjectManager projMngr = null;
    private static PPaths paths = null;
    private static MainFrame mainFrame = null;
    private static Registry rmiRegistry = null;
    private static PResourceBundle resourceBundle = null;
    private static boolean debugMode = false;

    private PEmulator() {
    }

    public static void setActivePeripheral(String string) {
        PEmulator.setActivePeripheral(PEmulator.getPeripheral(string));
    }

    public static void setActivePeripheral(IPPeripheral iPPeripheral) {
        PEmulator.getMainFrame().getRootPane().setDefaultButton(null);
        activePeripheral = iPPeripheral;
    }

    public static IPPeripheral getActivePeripheral() {
        return activePeripheral;
    }

    public static Enumeration getPeripherals() {
        return peripherals.elements();
    }

    public static IPPeripheral getPeripheral(String string) {
        Enumeration enumeration = peripherals.elements();
        while (enumeration.hasMoreElements()) {
            IPPeripheral iPPeripheral = (IPPeripheral)enumeration.nextElement();
            if (!string.equalsIgnoreCase(iPPeripheral.getName())) continue;
            return iPPeripheral;
        }
        return null;
    }

    public static IPPeripheral getPeriperal(int n) {
        if (n >= peripherals.size()) {
            return null;
        }
        return (IPPeripheral)peripherals.get(n);
    }

    public static MainFrame getMainFrame() {
        return mainFrame;
    }

    public static IPLog getLog() {
        block2: {
            if (log != null) break block2;
            try {
                log = new PLog();
            }
            catch (Exception exception) {
                PEmulator.criticalExceptionOcurred(PEmulator.getResourceBundle().getString("DIALOG_MSG_UNABLE_TO_CREATE_TRACE_FILE"), exception);
            }
        }
        return log;
    }

    public static PResourceBundle getResourceBundle() {
        if (resourceBundle == null) {
            resourceBundle = new PResourceBundle("pios.emulator.language.emulator");
        }
        return resourceBundle;
    }

    public static ImageIcon getImageIcon(String string) {
        return new ImageIcon(PEmulator.getPaths().getImagesDir() + "/" + string);
    }

    public static PProjectManager getProjectManager() {
        if (projMngr == null) {
            projMngr = new PProjectManager();
        }
        return projMngr;
    }

    public static PPaths getPaths() {
        if (paths == null) {
            paths = new PPaths();
        }
        return paths;
    }

    public static void loadDriverRequirementsDocument(File file) throws PEmulatorException {
        DriverRequirementsDocument driverRequirementsDocument = new DriverRequirementsDocument(file);
        Enumeration enumeration = PEmulator.getPeripherals();
        while (enumeration.hasMoreElements()) {
            IPPeripheral iPPeripheral = (IPPeripheral)enumeration.nextElement();
            PeripheralRequirements peripheralRequirements = driverRequirementsDocument.getPeripheral(iPPeripheral.getName());
            if (peripheralRequirements == null) continue;
            iPPeripheral.applyReq(peripheralRequirements.getAttributes());
        }
    }

    private static void startup(String string) {
        block24: {
            Object object;
            PEmulator.getLog().appendMessage("PEmulator starting up...");
            PEmulator.getLog().appendMessage("Using vm: " + System.getProperty("java.home"));
            PEmulator.getLog().appendMessage("VM Info: " + System.getProperty("java.vendor") + " version: " + System.getProperty("java.version"));
            PEmulator.getLog().appendMessage("System default language: " + Locale.getDefault());
            try {
                PEmulator.getLog().appendMessage("Setting MainFrame...");
                mainFrame = new MainFrame();
            }
            catch (Exception exception) {
                PEmulator.getLog().appendError("Error creating main screen", exception);
                PEmulator.criticalExceptionOcurred(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_CREATING_MAIN_SCREEN"), exception);
            }
            try {
                PEmulator.getLog().appendMessage("Initalizing RMI Registy...");
                rmiRegistry = LocateRegistry.createRegistry(PEmuProps.getInstance().getRemoteProxyPort());
                EmulatorEmServer emulatorEmServer = new EmulatorEmServer();
                rmiRegistry.rebind("RemoteEmulator", emulatorEmServer);
            }
            catch (Exception exception) {
                PEmulator.getLog().appendError("Error Initalizing RMI Registy", exception);
                PEmulator.criticalExceptionOcurred(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_INITALIZING_RMI_REGISTRY"), exception);
            }
            PEmulator.getLog().appendMessage("Loading peripherals...");
            boolean bl = false;
            Vector vector = null;
            try {
                vector = PDefinition.getPeripheralDefinitionList();
            }
            catch (IOException iOException) {
                PEmulator.getLog().appendError("Error loading peripheral definitions from the 'inst' folder", iOException);
                PEmulator.criticalExceptionOcurred(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_LOADING_PERIPHERAL_DEFINITIONS"), iOException);
            }
            if (vector.isEmpty()) {
                PEmulator.getMainFrame().enableDisableComponents();
            } else {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (PDefinition)enumeration.nextElement();
                    IPPeripheral iPPeripheral = null;
                    try {
                        String string2 = ((Properties)object).getProperty("CLASS");
                        iPPeripheral = (IPPeripheral)Class.forName(string2).newInstance();
                        peripherals.add(iPPeripheral);
                    }
                    catch (Exception exception) {
                        PEmulator.getLog().appendError("Error creating peripheral.", exception);
                        PEmulator.criticalExceptionOcurred(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_CREATING_PERIPHERAL"), exception);
                        continue;
                    }
                    PEmulator.getLog().appendMessage("Adding Peripheral to UI " + iPPeripheral.getName());
                    try {
                        PEmulator.getMainFrame().addPeripheral(iPPeripheral);
                        iPPeripheral.initAttributes((PDefinition)object);
                    }
                    catch (Exception exception) {
                        PEmulator.getLog().appendError("Error adding peripheral to UI: " + iPPeripheral.getName(), exception);
                        PEmulator.criticalExceptionOcurred(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_ADDING_PERIPHERAL_TO_UI", new Object[]{iPPeripheral.getName()}), exception);
                    }
                    PEmulator.getLog().appendMessage("Starting Peripheral " + iPPeripheral.getName());
                    try {
                        iPPeripheral.startup(rmiRegistry, PEmulator.getLog());
                    }
                    catch (Exception exception) {
                        PEmulator.getLog().appendError("Error starting peripheral: " + iPPeripheral.getName(), exception);
                        PEmulator.criticalExceptionOcurred(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_STARTING_PERIPHERAL", new Object[]{iPPeripheral.getName()}), exception);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        PEmulator.getLog().appendError("Error starting peripheral: " + iPPeripheral.getName(), noSuchMethodError);
                        PEmulator.criticalExceptionOcurred(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_STARTING_PERIPHERAL", new Object[]{iPPeripheral.getName()}), noSuchMethodError);
                    }
                    if (bl) continue;
                    PEmulator.setActivePeripheral(iPPeripheral);
                    bl = true;
                }
            }
            mainFrame.setIconImage(PEmulator.getImageIcon(resourceBundle.getString("IMAGE.EMULATOR_ICON")).getImage());
            mainFrame.show();
            PEmulator.getLog().appendMessage("Loading projects...");
            try {
                if (!PEmulator.getProjectManager().openLastProject()) {
                    PEmulator.getProjectManager().newProject();
                }
            }
            catch (PEmulatorException pEmulatorException) {
                try {
                    object = PEmuProps.getInstance().getLastOpenProject();
                }
                catch (Exception exception) {
                    object = "";
                }
                PDialog.errorDialog(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_OPENING_PROJECT", new Object[]{object}));
                PEmulator.getLog().appendWarning("Error loading last project: " + pEmulatorException.getMessage());
                PEmulator.getProjectManager().newProject();
            }
            if (!PEmulator.getPeripherals().hasMoreElements()) {
                mainFrame.enableMenuReq(false);
                return;
            }
            if (string == null || string.equals("")) break block24;
            try {
                PEmulator.loadDriverRequirementsDocument(new File(string));
                PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("STATUS_MSG_REQUIREMENTS_IMPORTED"), false);
            }
            catch (Exception exception) {
                PDialog.errorDialog(PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_IMPORTING_REQUIREMENTS"));
                PEmulator.getLog().appendError("Error reading Peripheral Requirements Document", exception);
            }
        }
    }

    public static void stop(int n) {
        PEmulator.getLog().appendMessage("Stopping PEmulator...");
        PEmulator.saveCurrentOpenProject();
        PEmulator.setActivePeripheral((IPPeripheral)null);
        PEmulator.getMainFrame().dispose();
        PEmulator.getLog().appendMessage("Exiting.");
        PEmulator.closeOpenObjects();
        System.exit(n);
    }

    public static boolean isDebugMode() {
        return debugMode;
    }

    private static void saveCurrentOpenProject() {
        PEmulator.getLog().appendMessage("Saving current open project...");
        PProject pProject = PEmulator.getProjectManager().getActiveProject();
        PEmuProps pEmuProps = null;
        try {
            pEmuProps = PEmuProps.getInstance();
        }
        catch (PEmulatorException pEmulatorException) {
            PEmulator.getLog().appendError("Error getting the properties file to update it", pEmulatorException);
            return;
        }
        PEmulator.getLog().appendMessage("Saving the currently open project...");
        if (!pProject.isNew()) {
            pEmuProps.setLastOpenProject(pProject.getProjectLocation());
        } else {
            pEmuProps.setLastOpenProject("");
        }
        try {
            pEmuProps.save();
        }
        catch (PEmulatorException pEmulatorException) {
            PEmulator.getLog().appendError(pEmulatorException.getMessage(), pEmulatorException);
        }
    }

    private static void criticalExceptionOcurred(String string, Throwable throwable) {
        PEmulator.closeOpenObjects();
        PDialog.errorDialog(string + " \n" + PEmulator.getResourceBundle().getString("DIALOG_MSG_ERROR_CHECK_LOG"));
        System.exit(0);
    }

    private static void closeOpenObjects() {
        if (log != null) {
            log.appendMessage("Closing peripherals...");
        }
        if (peripherals.size() > 0) {
            Iterator iterator = peripherals.iterator();
            while (iterator.hasNext()) {
                ((IPPeripheral)iterator.next()).close();
            }
        }
        if (log != null) {
            ((PLog)log).close();
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = null;
        if (stringArray != null && stringArray.length > 0) {
            string = stringArray[0];
        }
        if (System.getProperty("DEBUG") != null && System.getProperty("DEBUG").equals("true")) {
            debugMode = true;
        }
        PEmulator.startup(string);
        try {
            while (true) {
                if (System.in.available() > 0) {
                    byte[] byArray = new byte[System.in.available()];
                    System.in.read(byArray);
                    if (new String(byArray).equals("close")) {
                        PEmulator.stop(0);
                    }
                }
                Thread.sleep(500L);
            }
        }
        catch (Exception exception) {
            return;
        }
    }
}

