/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Properties;
import pios.emulator.PEmulatorException;
import pios.emulator.PPaths;

public class PEmuProps {
    private static final String VERSION = "version";
    private static final String LAST_OPEN_PROJECT = "LastOpenProject";
    private static final String TRACE = "Trace";
    private static final String REMOTE_PROXY_HOST = "RemoteProxyHost";
    private static final String REMOTE_PROXY_PORT = "RemoteProxyPort";
    private static final String DEFAULT_VERSION = "";
    private static final String DEFAULT_LAST_OPEN_PROJECT = "";
    private static final String DEFAULT_TRACE_LEVEL = "1";
    private static final String DEFAULT_REMOTE_PROXY_HOST = "localhost";
    private static final String DEFAULT_REMOTE_PROXY_PORT = "3346";
    private String propfile = "emulator.properties";
    private Properties props = new Properties();
    private static PEmuProps _instance;

    private PEmuProps() throws PEmulatorException {
        this.propfile = new PPaths().getConfigDir() + "/" + this.propfile;
        this.load();
    }

    public String getLastOpenProject() {
        return this.props.getProperty(LAST_OPEN_PROJECT, "");
    }

    public void setLastOpenProject(String string) {
        this.props.setProperty(LAST_OPEN_PROJECT, string);
    }

    public int getTraceLevel() {
        return Integer.parseInt(this.props.getProperty(TRACE, DEFAULT_TRACE_LEVEL));
    }

    public String getVersion() {
        return this.props.getProperty(VERSION, "");
    }

    public String getRemoteProxyHost() {
        return this.props.getProperty(REMOTE_PROXY_HOST, DEFAULT_REMOTE_PROXY_HOST);
    }

    public int getRemoteProxyPort() {
        return Integer.parseInt(this.props.getProperty(REMOTE_PROXY_PORT, DEFAULT_REMOTE_PROXY_PORT));
    }

    /*
     * Loose catch block
     */
    public void save() throws PEmulatorException {
        block11: {
            FileOutputStream fileOutputStream = null;
            FilterOutputStream filterOutputStream = null;
            fileOutputStream = new FileOutputStream(this.propfile);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            this.props.store(filterOutputStream, "Emulator Properties");
            Object var5_3 = null;
            try {
                filterOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (IOException iOException) {
                    throw new PEmulatorException("Error saving the properties file.", iOException);
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void load() throws PEmulatorException {
        block27: {
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            fileInputStream = new FileInputStream(new File(this.propfile));
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            this.props.load(bufferedInputStream);
            Object var12_3 = null;
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            break block27;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    block28: {
                        String string = new PPaths().getConfigDir();
                        FileOutputStream fileOutputStream = null;
                        FilterOutputStream filterOutputStream = null;
                        File file = new File(string);
                        if (!file.exists()) {
                            file.mkdir();
                        }
                        this.props.put(LAST_OPEN_PROJECT, "");
                        this.props.put(TRACE, DEFAULT_TRACE_LEVEL);
                        this.props.put(REMOTE_PROXY_HOST, DEFAULT_REMOTE_PROXY_HOST);
                        this.props.put(REMOTE_PROXY_PORT, DEFAULT_REMOTE_PROXY_PORT);
                        fileOutputStream = new FileOutputStream(this.propfile);
                        filterOutputStream = new BufferedOutputStream(fileOutputStream);
                        this.props.store(filterOutputStream, "Emulator Properties");
                        Object var9_16 = null;
                        try {
                            filterOutputStream.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception) {}
                        break block28;
                        {
                            catch (IOException iOException) {
                                throw new PEmulatorException("Error creating config file in directory: " + string + ".", iOException);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_17 = null;
                            try {
                                filterOutputStream.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                fileOutputStream.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                    Object var12_4 = null;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                    break block27;
                }
                catch (IOException iOException) {
                    throw new PEmulatorException("Error loading configuration file: " + this.propfile + ".", iOException);
                }
            }
            catch (Throwable throwable) {
                Object var12_5 = null;
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static PEmuProps getInstance() throws PEmulatorException {
        if (_instance == null) {
            _instance = new PEmuProps();
        }
        return _instance;
    }
}

