/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import pios.emulator.PEmulator;
import pios.emulator.PropertiesFileFilter;

public class PDefinition
extends Properties {
    public static final String PERF_TYPE = "PERIPHERAL";
    public static final String PERF_MODEL = "MODEL";
    public static final String PERF_MODEL_EM = "Emulator";
    public static final String PERF_VERSION = "VERSION";
    public static final String PERF_CLASS = "CLASS";

    private PDefinition() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDefinition(File file) throws IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            this.load(bufferedInputStream);
            if (!this.validate()) {
                throw new IOException("Invalid peripheral file content. " + file);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {}
    }

    private boolean validate() {
        String string = this.getProperty(PERF_TYPE);
        if (string == null) {
            return false;
        }
        String string2 = this.getProperty(PERF_MODEL);
        return string2.equalsIgnoreCase(PERF_MODEL_EM);
    }

    public String getType() {
        return this.getProperty(PERF_TYPE);
    }

    public String getVersion() {
        return this.getProperty(PERF_VERSION);
    }

    public static Vector getPeripheralDefinitionList() throws IOException {
        String string = PEmulator.getPaths().getPerfDir();
        File[] fileArray = new File(string).listFiles(new PropertiesFileFilter());
        if (fileArray == null) {
            return null;
        }
        Vector<PDefinition> vector = new Vector<PDefinition>();
        int n = 0;
        while (n < fileArray.length) {
            vector.addElement(new PDefinition(fileArray[n]));
            ++n;
        }
        return vector;
    }
}

