/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pios.emulator.PDialog;
import pios.emulator.PEmulator;
import pios.emulator.PPeripheralException;
import pios.emulator.PProject;
import pios.emulator.actions.AboutAction;
import pios.emulator.actions.DeleteDataAction;
import pios.emulator.actions.ExitEmulatorAction;
import pios.emulator.actions.ImportReqAction;
import pios.emulator.actions.NewDataAction;
import pios.emulator.actions.NewProjectAction;
import pios.emulator.actions.OpenProjectAction;
import pios.emulator.actions.RenameDataAction;
import pios.emulator.actions.SaveAsProjectAction;
import pios.emulator.actions.SaveProjectAction;
import pios.emulator.api.IPData;
import pios.emulator.api.IPDataHandler;
import pios.emulator.api.IPDataSet;
import pios.emulator.api.IPPeripheral;
import pios.emulator.ui.GBC;
import pios.emulator.ui.MenuToolbarMenuOption;
import pios.emulator.ui.MenuToolbarOption;
import pios.emulator.ui.PResourceBundle;

public class MainFrame
extends JFrame
implements WindowListener,
ComponentListener {
    private static final int PANEL_MIN_WIDTH = 780;
    private static final int PANEL_MIN_HEIGHT = 650;
    private JTree treeProject = new JTree();
    private JTabbedPane tabbedPanePeripherals = new JTabbedPane();
    private JPanel statusPanel = new JPanel(new FlowLayout(0, 5, 0));
    private JSplitPane splitPane = new JSplitPane();
    private ButtonGroup groupPeripherals = new ButtonGroup();
    private JLabel labelStatus = new JLabel();
    private JToolBar toolbar = new JToolBar();
    private JToolBar toolBarPeripheral = new JToolBar();
    private MenuToolbarOption optionNewProject = null;
    private MenuToolbarOption optionOpenProject = null;
    private MenuToolbarOption optionSaveProject = null;
    private MenuToolbarOption optionSaveProjectAs = null;
    private JMenuItem menuItemExit = null;
    private ExitEmulatorAction actionExit = new ExitEmulatorAction();
    private MenuToolbarMenuOption optionNewData = null;
    private MenuToolbarMenuOption optionRenameData = null;
    private MenuToolbarMenuOption optionDeleteData = null;
    private JMenu menuView = null;
    private JMenu menuSelectPeripheral = null;
    private JMenu menuEdit = null;
    private MenuToolbarOption optionImportRequirements = null;
    private JMenu menuPeripheralOptions = null;
    private DefaultMutableTreeNode currentPeripheralNode = null;
    private DefaultMutableTreeNode selectedNode = null;
    private JPopupMenu popupMenuTreeData = new JPopupMenu();
    private PResourceBundle resourceBundle = PEmulator.getResourceBundle();
    private boolean tempSetPeripheralFocus = true;

    public MainFrame() throws Exception {
        this.setSize(780, 650);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.setResizable(true);
        this.setTitle(this.resourceBundle.getString("MAIN_TITTLE"));
        this.getContentPane().setLayout(new BorderLayout());
        this.initOptions();
        this.statusPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusPanel.setMinimumSize(new Dimension(10, 40));
        this.statusPanel.setPreferredSize(new Dimension(14, 20));
        this.labelStatus.setHorizontalAlignment(2);
        this.statusPanel.add(this.labelStatus);
        JScrollPane jScrollPane = new JScrollPane(this.treeProject);
        jScrollPane.setPreferredSize(new Dimension(160, 64));
        this.tabbedPanePeripherals.setMinimumSize(new Dimension(450, -1));
        this.tabbedPanePeripherals.setPreferredSize(new Dimension(550, -1));
        this.splitPane = new JSplitPane(1, jScrollPane, this.tabbedPanePeripherals);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.treeProject.setModel(null);
        this.treeProject.getSelectionModel().setSelectionMode(1);
        JMenuBar jMenuBar = new JMenuBar();
        this.createProjectMenuOptions(jMenuBar);
        this.createEditMenu(jMenuBar);
        this.createViewMenu(jMenuBar);
        if (PEmulator.isDebugMode()) {
            this.createReqMenu(jMenuBar);
        }
        jMenuBar.add(this.menuPeripheralOptions);
        this.setMnemonic(this.menuPeripheralOptions, "MAIN_OPTION_PERIPHERAL_OPTIONS.MNEMONIC");
        this.createHelpMenu(jMenuBar);
        this.setJMenuBar(jMenuBar);
        this.toolbar.setFloatable(false);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, "West");
        jPanel2.add((Component)this.toolbar, new GBC(0, 0, 1, 1, 0.0, 0.0, 17, 0, 0, 0, 0, 0));
        this.toolBarPeripheral.setVisible(false);
        this.toolBarPeripheral.setFloatable(false);
        jPanel2.add((Component)this.toolBarPeripheral, new GBC(1, 0, 1, 1, 100.0, 0.0, 17, 0, 0, 0, 0, 0));
        this.tabbedPanePeripherals.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MainFrame.this.peripheralTabSelected();
            }
        });
        this.treeProject.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    if (PEmulator.getActivePeripheral() == null) {
                        MainFrame.this.tabbedPanePeripherals.requestFocus();
                    } else {
                        PEmulator.getActivePeripheral().setFocus();
                    }
                }
            }
        });
    }

    private void initOptions() {
        this.optionNewProject = new MenuToolbarOption(this.resourceBundle.getString("MAIN_OPTION_NEW_PROJECT"), new NewProjectAction());
        this.optionOpenProject = new MenuToolbarOption(this.resourceBundle.getString("MAIN_OPTION_OPEN_PROJECT"), new OpenProjectAction());
        this.optionSaveProject = new MenuToolbarOption(this.resourceBundle.getString("MAIN_OPTION_SAVE_PROJECT"), new SaveProjectAction());
        this.optionSaveProjectAs = new MenuToolbarOption(this.resourceBundle.getString("MAIN_OPTION_SAVE_PROJECT_AS"), new SaveAsProjectAction());
        this.menuItemExit = new JMenuItem(this.resourceBundle.getString("MAIN_OPTION_EXIT"));
        this.optionNewData = new MenuToolbarMenuOption(this.resourceBundle.getString("MAIN_OPTION_NEW_DATA"), new NewDataAction());
        this.optionRenameData = new MenuToolbarMenuOption(this.resourceBundle.getString("MAIN_OPTION_RENAME_DATA"), new RenameDataAction());
        this.optionDeleteData = new MenuToolbarMenuOption(this.resourceBundle.getString("MAIN_OPTION_DELETE_DATA"), new DeleteDataAction());
        this.menuEdit = new JMenu(this.resourceBundle.getString("MAIN_OPTION_EDIT"));
        this.optionImportRequirements = new MenuToolbarOption(this.resourceBundle.getString("MAIN_OPTION_IMPORT_REQUIREMENTS"), new ImportReqAction());
        this.menuPeripheralOptions = new JMenu(this.resourceBundle.getString("MAIN_OPTION_PERIPHERAL_OPTIONS"));
    }

    public void loadProjectIntoTree(PProject pProject) {
        PEmulator.getLog().appendMessage("Creating nodes for " + pProject.toString() + "...");
        Enumeration enumeration = PEmulator.getPeripherals();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        JTree.DynamicUtilTreeNode dynamicUtilTreeNode = new JTree.DynamicUtilTreeNode((Object)pProject, vector);
        Enumeration<? extends TreeNode> enumeration2 = dynamicUtilTreeNode.children();
        while (enumeration2.hasMoreElements()) {
            Enumeration enumeration3;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration2.nextElement();
            defaultMutableTreeNode.setAllowsChildren(true);
            IPDataSet iPDataSet = ((IPPeripheral)defaultMutableTreeNode.getUserObject()).getDataHandler().getDataSet();
            if (iPDataSet == null || !(enumeration3 = iPDataSet.getDataList().elements()).hasMoreElements()) continue;
            while (enumeration3.hasMoreElements()) {
                IPData iPData = (IPData)enumeration3.nextElement();
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(iPData);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
        this.treeProject.setModel(new DefaultTreeModel(dynamicUtilTreeNode));
        this.treeProject.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MainFrame.this.treeNodeSelected(treeSelectionEvent);
            }
        });
        this.treeProject.setSelectionPath(new TreePath(this.treeProject.getModel().getRoot()));
        this.treeProject.addMouseListener(new MouseListener(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && MainFrame.this.selectedNode != null && MainFrame.this.selectedNode != MainFrame.this.treeProject.getModel().getRoot()) {
                    MainFrame.this.popupMenuTreeData.show(MainFrame.this.treeProject, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger() && MainFrame.this.selectedNode != null && MainFrame.this.selectedNode != MainFrame.this.treeProject.getModel().getRoot()) {
                    MainFrame.this.popupMenuTreeData.show(MainFrame.this.treeProject, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }
        });
        this.enableDisableComponents();
        this.setTitle(this.resourceBundle.getString("MAIN_TITTLE") + " - " + pProject.toString());
        this.peripheralTabSelected();
    }

    public void addDataToTree(IPData iPData) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(iPData);
        this.currentPeripheralNode.add(defaultMutableTreeNode);
        this.treeProject.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    public void removeSelectedDataFromTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.selectedNode.getPreviousNode();
        this.selectedNode.removeFromParent();
        this.treeProject.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        this.treeProject.updateUI();
    }

    public void addPeripheral(IPPeripheral iPPeripheral) throws PPeripheralException {
        this.tabbedPanePeripherals.addTab(iPPeripheral.getLocalizedName(), PEmulator.getImageIcon(iPPeripheral.getImageName()), iPPeripheral.createUIContent());
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(iPPeripheral.getLocalizedName());
        this.menuSelectPeripheral.add(jRadioButtonMenuItem);
        this.groupPeripherals.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.addActionListener(new AbstractAction(iPPeripheral.getLocalizedName()){

            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)actionEvent.getSource();
                PEmulator.setActivePeripheral(jRadioButtonMenuItem.getText());
                MainFrame.this.moveToCurrentActivePeripheral();
                PEmulator.getActivePeripheral().setFocus();
            }
        });
    }

    public void refreshTree(PProject pProject) {
        this.treeProject.updateUI();
        this.setTitle(this.resourceBundle.getString("MAIN_TITTLE") + " - " + pProject.toString());
    }

    public void moveToCurrentActivePeripheral() {
        int n = 0;
        while (n < this.menuSelectPeripheral.getItemCount()) {
            JMenuItem jMenuItem = this.menuSelectPeripheral.getItem(n);
            if (jMenuItem != null && PEmulator.getActivePeripheral().getLocalizedName().equalsIgnoreCase(jMenuItem.getText())) {
                jMenuItem.setSelected(true);
            }
            ++n;
        }
        this.tempSetPeripheralFocus = false;
        int n2 = this.tabbedPanePeripherals.indexOfTab(PEmulator.getActivePeripheral().getLocalizedName());
        if (n2 != -1 && n2 != this.tabbedPanePeripherals.getSelectedIndex()) {
            this.tabbedPanePeripherals.setSelectedIndex(n2);
        } else if (n2 != -1) {
            this.peripheralTabSelected();
        }
        this.tempSetPeripheralFocus = true;
    }

    public void moveToProjectRoot() {
        this.currentPeripheralNode = null;
        this.selectedNode = null;
        this.treeProject.setSelectionPath(new TreePath(this.treeProject.getModel().getRoot()));
        this.enableDisableComponents();
    }

    public void setStatusMessage(String string, boolean bl) {
    }

    public void setStatusMessage(String string, boolean bl, boolean bl2) {
    }

    public JTree getProjectTree() {
        return this.treeProject;
    }

    public void enableMenuReq(boolean bl) {
        this.optionImportRequirements.setEnabled(bl);
    }

    public JMenu getPeripheralOptionMenu() {
        return this.menuPeripheralOptions;
    }

    public JToolBar getPeripheralToolBar() {
        return this.toolBarPeripheral;
    }

    public AbstractAction getNewProjectAction() {
        return this.optionNewProject.getAction();
    }

    public AbstractAction getSaveAsAction() {
        return this.optionSaveProjectAs.getAction();
    }

    public AbstractAction getSaveProjectAction() {
        return this.optionSaveProject.getAction();
    }

    public AbstractAction getNewDataAction() {
        return this.optionNewData.getAction();
    }

    public AbstractAction getRenameDataAction() {
        return this.optionRenameData.getAction();
    }

    public AbstractAction getDeleteDataAction() {
        return this.optionDeleteData.getAction();
    }

    public void enableDisableComponents() {
        if (PEmulator.getActivePeripheral() != null && PEmulator.getActivePeripheral().supportsData()) {
            this.optionNewData.setEnabled(true);
            if (PEmulator.getActivePeripheral().getDataHandler().getActiveData() == null) {
                this.optionRenameData.setEnabled(false);
                this.optionDeleteData.setEnabled(false);
            } else {
                this.optionRenameData.setEnabled(true);
                this.optionDeleteData.setEnabled(true);
            }
        } else {
            this.optionNewData.setEnabled(false);
            this.optionRenameData.setEnabled(false);
            this.optionDeleteData.setEnabled(false);
        }
        if (this.menuPeripheralOptions.getItemCount() == 0) {
            this.menuPeripheralOptions.setEnabled(false);
            this.toolBarPeripheral.setVisible(false);
        } else {
            this.menuPeripheralOptions.setEnabled(true);
            this.toolBarPeripheral.setVisible(true);
        }
    }

    private void peripheralTabSelected() {
        if (this.tabbedPanePeripherals.getSelectedIndex() > -1) {
            IPPeripheral iPPeripheral = PEmulator.getPeriperal(this.tabbedPanePeripherals.getSelectedIndex());
            if (this.tempSetPeripheralFocus) {
                iPPeripheral.setFocus();
            }
            IPDataHandler iPDataHandler = iPPeripheral.getDataHandler();
            Object object = null;
            object = iPDataHandler.getDataSet() != null && iPDataHandler.getActiveData() != null ? iPDataHandler.getActiveData() : iPPeripheral;
            if (this.treeProject.getModel() != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treeProject.getModel().getRoot();
                int n = 0;
                while (n < defaultMutableTreeNode.getChildCount()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
                    if (defaultMutableTreeNode2.getUserObject() == object) {
                        this.treeProject.setSelectionPath(new TreePath(defaultMutableTreeNode2.getPath()));
                        return;
                    }
                    int n2 = 0;
                    while (n2 < defaultMutableTreeNode2.getChildCount()) {
                        DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getChildAt(n2);
                        if (defaultMutableTreeNode3.getUserObject() == object) {
                            this.treeProject.setSelectionPath(new TreePath(defaultMutableTreeNode3.getPath()));
                            return;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
            PEmulator.setActivePeripheral(iPPeripheral);
        }
    }

    private void treeNodeSelected(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.selectedNode;
        this.selectedNode = (DefaultMutableTreeNode)((JTree)treeSelectionEvent.getSource()).getLastSelectedPathComponent();
        if (this.selectedNode == null) {
            return;
        }
        Object object = this.selectedNode.getUserObject();
        if (object instanceof IPData) {
            int n;
            IPData iPData = (IPData)object;
            this.currentPeripheralNode = (DefaultMutableTreeNode)this.selectedNode.getParent();
            IPPeripheral iPPeripheral = (IPPeripheral)this.currentPeripheralNode.getUserObject();
            if (PEmulator.getActivePeripheral() != iPPeripheral) {
                PEmulator.setActivePeripheral(iPPeripheral);
            }
            if (defaultMutableTreeNode != this.selectedNode && iPData != iPPeripheral.getDataHandler().getActiveData() && iPPeripheral.hasPendingChanges() && (n = PDialog.yesNoDialog(this.resourceBundle.getString("DIALOG_MSG_LOOSE_PERF_UNSAVED_CHANGES", new Object[]{iPPeripheral.getLocalizedName(), iPPeripheral.getDataHandler().getActiveData().getName()}), this.resourceBundle.getString("DIALOG_MSG_LOOSE_PERF_UNSAVED_CHANGES_HEADER"))) != 0) {
                this.selectedNode = defaultMutableTreeNode;
                this.treeProject.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
                return;
            }
            iPPeripheral.getDataHandler().setActiveData(iPData);
        } else if (object instanceof IPPeripheral) {
            this.currentPeripheralNode = this.selectedNode;
            IPPeripheral iPPeripheral = (IPPeripheral)this.selectedNode.getUserObject();
            PEmulator.setActivePeripheral(iPPeripheral);
            if (iPPeripheral.hasPendingChanges() && PDialog.yesNoDialog(this.resourceBundle.getString("DIALOG_MSG_LOOSE_PERF_UNSAVED_CHANGES", new Object[]{iPPeripheral.getLocalizedName(), iPPeripheral.getDataHandler().getActiveData().getName()}), this.resourceBundle.getString("DIALOG_MSG_LOOSE_PERF_UNSAVED_CHANGES_HEADER")) != 0) {
                this.selectedNode = defaultMutableTreeNode;
                this.treeProject.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
                return;
            }
            iPPeripheral.getDataHandler().setActiveData(null);
            this.treeProject.expandPath(new TreePath(this.currentPeripheralNode.getPath()));
        } else {
            this.currentPeripheralNode = null;
            if (PEmulator.getActivePeripheral() != null) {
                IPPeripheral iPPeripheral = PEmulator.getActivePeripheral();
                if (iPPeripheral.hasPendingChanges() && PDialog.yesNoDialog(this.resourceBundle.getString("DIALOG_MSG_LOOSE_PERF_UNSAVED_CHANGES", new Object[]{iPPeripheral.getLocalizedName(), iPPeripheral.getDataHandler().getActiveData().getName()}), this.resourceBundle.getString("DIALOG_MSG_LOOSE_PERF_UNSAVED_CHANGES_HEADER")) != 0) {
                    this.selectedNode = defaultMutableTreeNode;
                    this.treeProject.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
                    return;
                }
                PEmulator.getActivePeripheral().getDataHandler().setActiveData(null);
            }
            PEmulator.setActivePeripheral((IPPeripheral)null);
        }
        if (this.currentPeripheralNode != null) {
            this.menuPeripheralOptions.removeAll();
            PEmulator.getActivePeripheral().populateMenu(this.menuPeripheralOptions);
            this.toolBarPeripheral.removeAll();
            PEmulator.getActivePeripheral().populateToolbar(this.toolBarPeripheral);
            this.toolBarPeripheral.updateUI();
            this.moveToCurrentActivePeripheral();
        }
        this.enableDisableComponents();
    }

    private void selectProjectTree() {
        this.treeProject.requestFocus();
    }

    private void selectPeripheralsPanel() {
        if (PEmulator.getActivePeripheral() == null) {
            this.tabbedPanePeripherals.requestFocus();
        } else {
            PEmulator.getActivePeripheral().setFocus();
        }
    }

    private void createProjectMenuOptions(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(this.resourceBundle.getString("MAIN_OPTION_FILE"));
        this.menuItemExit.setAction(this.actionExit);
        this.toolbar.add(this.optionNewProject.getToolbarButton());
        this.toolbar.add(this.optionOpenProject.getToolbarButton());
        this.toolbar.add(this.optionSaveProject.getToolbarButton());
        this.toolbar.add(this.optionSaveProjectAs.getToolbarButton());
        this.toolbar.addSeparator();
        jMenu.add(this.optionNewProject.getMenuItem());
        jMenu.add(this.optionOpenProject.getMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.optionSaveProject.getMenuItem());
        jMenu.add(this.optionSaveProjectAs.getMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.menuItemExit);
        jMenuBar.add(jMenu);
        this.setMnemonic(jMenu, "MAIN_OPTION_FILE.MNEMONIC");
        this.setMnemonic(this.optionNewProject.getMenuItem(), "MAIN_OPTION_NEW_PROJECT.MNEMONIC");
        this.setMnemonic(this.optionOpenProject.getMenuItem(), "MAIN_OPTION_OPEN_PROJECT.MNEMONIC");
        this.setMnemonic(this.optionSaveProject.getMenuItem(), "MAIN_OPTION_SAVE_PROJECT.MNEMONIC");
        this.setMnemonic(this.optionSaveProjectAs.getMenuItem(), "MAIN_OPTION_SAVE_PROJECT_AS.MNEMONIC");
        this.setMnemonic(this.menuItemExit, "MAIN_OPTION_EXIT.MNEMONIC");
        this.optionOpenProject.getMenuItem().setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.optionSaveProject.getMenuItem().setAccelerator(KeyStroke.getKeyStroke(83, 2));
    }

    private void createEditMenu(JMenuBar jMenuBar) {
        this.toolbar.add(this.optionNewData.getToolbarButton());
        this.toolbar.add(this.optionRenameData.getToolbarButton());
        this.toolbar.add(this.optionDeleteData.getToolbarButton());
        this.toolbar.addSeparator();
        this.menuEdit.add(this.optionNewData.getMenuItem());
        this.menuEdit.add(this.optionRenameData.getMenuItem());
        this.menuEdit.add(this.optionDeleteData.getMenuItem());
        this.popupMenuTreeData.add(this.optionNewData.getPopupMenuItem());
        this.popupMenuTreeData.add(this.optionRenameData.getPopupMenuItem());
        this.popupMenuTreeData.add(this.optionDeleteData.getPopupMenuItem());
        jMenuBar.add(this.menuEdit);
        this.setMnemonic(this.menuEdit, "MAIN_OPTION_EDIT.MNEMONIC");
        this.setMnemonic(this.optionNewData.getMenuItem(), "MAIN_OPTION_NEW_DATA.MNEMONIC");
        this.setMnemonic(this.optionRenameData.getMenuItem(), "MAIN_OPTION_RENAME_DATA.MNEMONIC");
        this.setMnemonic(this.optionDeleteData.getMenuItem(), "MAIN_OPTION_DELETE_DATA.MNEMONIC");
    }

    private void createViewMenu(JMenuBar jMenuBar) {
        this.menuView = new JMenu(this.resourceBundle.getString("MAIN_OPTION_VIEW"));
        this.setMnemonic(this.menuView, "MAIN_OPTION_VIEW.MNEMONIC");
        JMenuItem jMenuItem = new JMenuItem(this.resourceBundle.getString("MAIN_OPTION_VIEW_SELECT_PROJECT_TREE"));
        this.setMnemonic(jMenuItem, "MAIN_OPTION_VIEW_SELECT_PROJECT_TREE.MNEMONIC");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        JMenuItem jMenuItem2 = new JMenuItem(this.resourceBundle.getString("MAIN_OPTION_VIEW_SELECT_PERIPHERAL_PANEL"));
        this.setMnemonic(jMenuItem2, "MAIN_OPTION_VIEW_SELECT_PERIPHERAL_PANEL.MNEMONIC");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.menuView.add(jMenuItem);
        this.menuView.add(jMenuItem2);
        this.menuView.addSeparator();
        this.menuSelectPeripheral = new JMenu(this.resourceBundle.getString("MAIN_OPTION_VIEW_SELECT_PERIPHERAL"));
        this.setMnemonic(this.menuSelectPeripheral, "MAIN_OPTION_VIEW_SELECT_PERIPHERAL.MNEMONIC");
        this.menuView.add(this.menuSelectPeripheral);
        jMenuBar.add(this.menuView);
        jMenuItem.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.selectProjectTree();
            }
        });
        jMenuItem2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.selectPeripheralsPanel();
            }
        });
    }

    private void createReqMenu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(this.resourceBundle.getString("MAIN_OPTION_REQUIREMENTS"));
        this.toolbar.add(this.optionImportRequirements.getToolbarButton());
        jMenu.add(this.optionImportRequirements.getMenuItem());
        jMenuBar.add(jMenu);
        this.setMnemonic(jMenu, "MAIN_OPTION_REQUIREMENTS.MNEMONIC");
        this.setMnemonic(this.optionImportRequirements.getMenuItem(), "MAIN_OPTION_IMPORT_REQUIREMENTS.MNEMONIC");
        this.optionImportRequirements.getMenuItem().setAccelerator(KeyStroke.getKeyStroke(73, 2));
    }

    private void createHelpMenu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(this.resourceBundle.getString("MAIN_OPTION_HELP"));
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setAction(new AboutAction());
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        this.setMnemonic(jMenu, "MAIN_OPTION_HELP.MNEMONIC");
        this.setMnemonic(jMenuItem, "MAIN_OPTION_ABOUT.MNEMONIC");
    }

    private boolean setMnemonic(AbstractButton abstractButton, String string) {
        String string2 = this.resourceBundle.getString(string);
        if (string2.length() > 0) {
            abstractButton.setMnemonic((int)string2.charAt(0));
            return true;
        }
        return false;
    }

    public void windowClosing(WindowEvent windowEvent) {
        ExitEmulatorAction exitEmulatorAction = new ExitEmulatorAction();
        exitEmulatorAction.setEnabled(true);
        exitEmulatorAction.actionPerformed(null);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.selectProjectTree();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }
}

