/*
 * Decompiled with CFR 0.152.
 */
package pios.emulator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import pios.emulator.PDialog;
import pios.emulator.PEmulator;
import pios.emulator.api.IPData;
import pios.emulator.ui.Accessability;
import pios.emulator.ui.GBC;

public class DataNameDialog
extends JDialog {
    public static final int NEW = 0;
    public static final int RENAME = 1;
    private JTextField textDataName = new JTextField();
    private int operationType;

    private DataNameDialog() {
    }

    public DataNameDialog(int n) {
        super((Frame)PEmulator.getMainFrame(), true);
        this.operationType = n;
        if (n == 1) {
            this.setTitle(PEmulator.getResourceBundle().getString("DATA_NAME_DIALOG.RENAME_DATA"));
        } else {
            this.setTitle(PEmulator.getResourceBundle().getString("DATA_NAME_DIALOG.NEW_DATA"));
        }
        this.setResizable(false);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        JLabel jLabel = new JLabel(PEmulator.getResourceBundle().getString("DATA_NAME_DIALOG.DATA_NAME"));
        jPanel.add((Component)jLabel, new GBC(0, 0, 1, 1, 0.0, 0.0, 17, 0, 10, 10, 0, 10));
        if (n == 1) {
            this.textDataName.setText(PEmulator.getActivePeripheral().getDataHandler().getActiveData().getName());
        } else {
            this.textDataName.setText("");
        }
        this.textDataName.setPreferredSize(new Dimension(200, this.textDataName.getPreferredSize().height));
        jPanel.add((Component)this.textDataName, new GBC(1, 0, 1, 1, 0.0, 0.0, 17, 2, 10, 0, 0, 10));
        JButton jButton = new JButton(PEmulator.getResourceBundle().getString("GENERIC_BUTTON.OK"));
        jPanel.add((Component)jButton, new GBC(2, 0, 1, 1, 0.0, 0.0, 13, 0, 10, 0, 0, 10));
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton();
        jPanel.add((Component)jButton2, new GBC(2, 1, 1, 1, 0.0, 0.0, 13, 0, 5, 0, 10, 10));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataNameDialog.this.ok();
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataNameDialog.this.close();
            }
        };
        jButton2.setAction(abstractAction);
        jButton2.setText(PEmulator.getResourceBundle().getString("GENERIC_BUTTON.CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataNameDialog.this.close();
            }
        });
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "CANCEL");
        ActionMap actionMap = this.getRootPane().getActionMap();
        actionMap.put("CANCEL", abstractAction);
        Accessability.setButtonsPreferredSize(new JButton[]{jButton, jButton2});
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(PEmulator.getMainFrame());
    }

    private void ok() {
        if (!this.validDataName(this.textDataName.getText())) {
            return;
        }
        if (this.operationType == 1) {
            PEmulator.getActivePeripheral().getDataHandler().getActiveData().setName(this.textDataName.getText());
            PEmulator.getMainFrame().getProjectTree().updateUI();
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("DATA_NAME_DIALOG.DATA_RENAMED"), false);
        } else {
            IPData iPData = PEmulator.getActivePeripheral().getDataHandler().getDataSet().createNewData(this.textDataName.getText());
            PEmulator.getMainFrame().addDataToTree(iPData);
            PEmulator.getMainFrame().getProjectTree().updateUI();
            PEmulator.getMainFrame().setStatusMessage(PEmulator.getResourceBundle().getString("DATA_NAME_DIALOG.DATA_CREATED", new String[]{PEmulator.getActivePeripheral().getName(), iPData.getName()}), false);
        }
        PEmulator.getProjectManager().setProjectUpdated();
        this.close();
    }

    private void close() {
        this.setVisible(false);
    }

    private boolean validDataName(String string) {
        boolean bl = true;
        if (string == null || string.trim().equals("")) {
            PDialog.errorDialog(PEmulator.getResourceBundle().getString("DATA_NAME_DIALOG.MISSING_DATA_NAME"));
            bl = false;
        } else if (string.indexOf(60) >= 0 || string.indexOf(62) >= 0 || string.indexOf(34) >= 0 || string.indexOf(39) >= 0 || string.indexOf(38) >= 0) {
            PDialog.errorDialog(PEmulator.getResourceBundle().getString("DATA_NAME_DIALOG.INVALID_DATA_NAME"));
            bl = false;
        }
        return bl;
    }
}

