/*
 * Decompiled with CFR 0.152.
 */
package pios.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Zip {
    private static final int BUFFER_LENGTH = 4096;

    private Zip() {
    }

    private static void copyInputStream(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = bufferedInputStream.read(byArray)) >= 0) {
            bufferedOutputStream.write(byArray, 0, n);
        }
    }

    private static String fixDirFormat(String string) {
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separator;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String string, String string2) throws IOException {
        ZipFile zipFile = null;
        File file = null;
        try {
            zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            string2 = Zip.fixDirFormat(string2);
            new File(string2).mkdirs();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                file = new File(string2 + zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                Zip.copyInputStream(bufferedInputStream, bufferedOutputStream);
                bufferedInputStream.close();
                bufferedOutputStream.close();
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                zipFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            zipFile.close();
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipFile(ZipFile zipFile, String string, String string2) throws IOException {
        File file = null;
        try {
            ZipEntry zipEntry = zipFile.getEntry(string2);
            if (zipEntry == null) {
                throw new FileNotFoundException();
            }
            string = Zip.fixDirFormat(string);
            new File(string).mkdirs();
            file = new File(string + zipEntry.getName());
            if (zipEntry.isDirectory()) {
                file.mkdirs();
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            Zip.copyInputStream(bufferedInputStream, bufferedOutputStream);
            bufferedInputStream.close();
            bufferedOutputStream.close();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String string, String string2) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
            zipOutputStream = new ZipOutputStream(bufferedOutputStream);
            string = Zip.fixDirFormat(string);
            Zip.addDirToZipFile(zipOutputStream, string, string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            zipOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addFileToZipFile(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        block5: {
            block4: {
                String string3 = string;
                if (string3.startsWith(string2)) {
                    string3 = string3.substring(string2.length());
                }
                ZipEntry zipEntry = new ZipEntry(string3);
                try {
                    zipOutputStream.putNextEntry(zipEntry);
                    if (zipEntry.isDirectory()) {
                        Object var8_5 = null;
                        break block4;
                    }
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zipOutputStream);
                    Zip.copyInputStream(bufferedInputStream, bufferedOutputStream);
                    bufferedInputStream.close();
                    bufferedOutputStream.flush();
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    zipOutputStream.closeEntry();
                    throw throwable;
                }
            }
            zipOutputStream.closeEntry();
            return;
        }
        Object var8_6 = null;
        zipOutputStream.closeEntry();
    }

    private static void addDirToZipFile(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    Zip.addFileToZipFile(zipOutputStream, string + fileArray[n].getName() + "/", string2);
                    Zip.addDirToZipFile(zipOutputStream, string + fileArray[n].getName() + "/", string2);
                } else {
                    Zip.addFileToZipFile(zipOutputStream, string + fileArray[n].getName(), string2);
                }
                ++n;
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < 100) {
                Zip.zip("D:\\temp\\zipit", "D:\\temp\\4fdb5c2402945cc2000000e77a2b7b66.zip");
                ++n;
            }
            System.out.println(System.currentTimeMillis() - l);
            l = System.currentTimeMillis();
            int n2 = 0;
            while (n2 < 100) {
                Zip.unzip("D:\\temp\\4fdb5c2402945cc2000000e77a2b7b66.zip", "D:\\temp\\zipit");
                ++n2;
            }
            System.out.println(System.currentTimeMillis() - l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

