/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.chartdesigner;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.IMetamodelSaveParticipant;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.BusinessGraphicsDimension;
import com.sap.ide.metamodel.webdynpro.component.view.uielement.BusinessGraphicsType;
import com.sap.ide.webdynpro.chartdesigner.BusinessGraphicsEditorInput;
import com.sap.ide.webdynpro.chartdesigner.ChartDesignerPlugin;
import com.sap.ide.webdynpro.chartdesigner.NativeWrapper;
import com.sap.ide.webdynpro.chartdesigner.update.UpdateManager;
import com.sap.tc.webdynpro.clientserver.uielib.graphics.impl.BusinessGraphics;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ChartEditorPart
extends EditorPart
implements IMetamodelSaveParticipant {
    private OleFrame mWebFrame = null;
    private OleAutomation mOleAutomation = null;
    private OleControlSite mWebControlSite = null;
    private boolean mActivated = false;
    private NativeWrapper mChartWrapper = null;
    private com.sap.ide.metamodel.webdynpro.component.view.uielement.BusinessGraphics mObject = null;
    private boolean mDirty = false;
    private String mFileName = null;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$chartdesigner$ChartEditorPart;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        BusinessGraphicsEditorInput bginput;
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof BusinessGraphicsEditorInput && (bginput = (BusinessGraphicsEditorInput)input).getDevelopmentObject() instanceof com.sap.ide.metamodel.webdynpro.component.view.uielement.BusinessGraphics) {
            this.mObject = (com.sap.ide.metamodel.webdynpro.component.view.uielement.BusinessGraphics)bginput.getDevelopmentObject();
        }
        this.setTitle(input.getName());
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        try {
            this.mWebFrame = new OleFrame(parent, 0);
            GridData lGridData = new GridData(1808);
            this.mWebFrame.setLayoutData((Object)lGridData);
            this.mWebControlSite = new OleControlSite((Composite)this.mWebFrame, 0, "SAPGraphics.Chart.1");
            this.mOleAutomation = new OleAutomation((OleClientSite)this.mWebControlSite);
            this.mChartWrapper = new NativeWrapper(this.mOleAutomation);
        }
        catch (SWTException ex) {
            ChartDesignerPlugin.internalError(class$com$sap$ide$webdynpro$chartdesigner$ChartEditorPart == null ? (class$com$sap$ide$webdynpro$chartdesigner$ChartEditorPart = ChartEditorPart.class$("com.sap.ide.webdynpro.chartdesigner.ChartEditorPart")) : class$com$sap$ide$webdynpro$chartdesigner$ChartEditorPart, "createChartControl", "An error ocurred. See error log for more details.", ex, false);
        }
        boolean bl = this.mActivated = this.mWebControlSite.doVerb(-5) == 0;
        if (this.mActivated) {
            this.mChartWrapper.putDesignMode();
        } else {
            ChartDesignerPlugin.internalError(class$com$sap$ide$webdynpro$chartdesigner$ChartEditorPart == null ? (class$com$sap$ide$webdynpro$chartdesigner$ChartEditorPart = ChartEditorPart.class$("com.sap.ide.webdynpro.chartdesigner.ChartEditorPart")) : class$com$sap$ide$webdynpro$chartdesigner$ChartEditorPart, "doVerb", "An error ocurred. See error log for more details.", null, false);
        }
        if (this.mObject != null) {
            String cust = this.mObject.getCustomizingXML();
            if (cust != null && !cust.equals("")) {
                this.mChartWrapper.setCustomizing(cust, true);
            }
            this.getDeltaXML();
            this.getConvenienceProperties();
            String data = this.mObject.getDemodataXML();
            if (data != null && !data.equals("")) {
                this.mChartWrapper.setDemoData(data);
            }
        }
        this.mWebControlSite.addEventListener(3, new OleListener(){

            public void handleEvent(OleEvent event) {
                ChartEditorPart.this.setXML();
            }
        });
        this.mWebControlSite.addEventListener(2, new OleListener(){

            public void handleEvent(OleEvent event) {
                ChartEditorPart.this.setXML();
            }
        });
    }

    private void setXML() {
        UpdateManager.beforeOperation();
        String cust = this.mChartWrapper.getCustomizing();
        this.mObject.setCustomizingXML(cust);
        String data = this.mChartWrapper.getDemoData();
        this.mObject.setDemodataXML(data);
        this.setConvenienceProperties();
        UpdateManager.afterOperation();
    }

    private void getDeltaXML() {
        try {
            URL url = new URL(this.mObject.getCustomizing());
            Object content = url.getContent();
            if (content instanceof FilterInputStream) {
                FilterInputStream input = (FilterInputStream)content;
                StringBuffer buffer = new StringBuffer();
                while (input.available() > 0) {
                    int b = input.read();
                    char c = (char)b;
                    buffer.append(c);
                }
                this.mChartWrapper.setCustomizing(buffer.toString(), false);
            }
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void getConvenienceProperties() {
        String backgroundColor = this.mObject.getBackgroundColor();
        String transparentColor = this.mObject.getTransparentColor();
        String fontFamily = this.mObject.getFontFamily();
        String height = String.valueOf(this.mObject.getHeight());
        String width = String.valueOf(this.mObject.getWidth());
        String chartType = this.getChartType();
        String dimension = this.getDimension();
        String xml = BusinessGraphics.createCuString((String)backgroundColor, (String)chartType, (String)dimension, (String)fontFamily, (String)height, (String)transparentColor, (String)width);
        this.mChartWrapper.setCustomizing(xml, false);
    }

    private void setConvenienceProperties() {
        String backgroundColor = this.mChartWrapper.getProperty("Background", "Color");
        this.mObject.setBackgroundColor(backgroundColor);
        String transparentColor = this.mChartWrapper.getProperty("GlobalSettings", "TransparentColor");
        this.mObject.setTransparentColor(transparentColor);
        String dimension = this.mChartWrapper.getProperty("GlobalSettings", "Dimension");
        this.setDimension(dimension);
        String chartType = this.mChartWrapper.getProperty("GlobalSettings", "ChartType");
        this.setChartType(chartType);
        String fontFamily = this.mChartWrapper.getProperty("GlobalSettings", "FontFamily");
        this.mObject.setFontFamily(fontFamily);
        String width = this.mChartWrapper.getProperty("GlobalSettings", "Width");
        try {
            this.mObject.setWidth(Integer.parseInt(width));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String height = this.mChartWrapper.getProperty("GlobalSettings", "Height");
        try {
            this.mObject.setHeight(Integer.parseInt(height));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    private void setDimension(String dimension) {
        BusinessGraphicsDimension dim = BusinessGraphicsDimension.valueOf((String)dimension.toLowerCase());
        if (dim != null) {
            this.mObject.setDimension(dim);
        }
    }

    private void setChartType(String chartType) {
        BusinessGraphicsType type = BusinessGraphicsType.valueOf((String)this.transform(chartType));
        if (type != null) {
            this.mObject.setChartType(type);
        }
    }

    private String transform(String chartType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Character.toLowerCase(chartType.charAt(0)));
        int i = 1;
        while (i < chartType.length()) {
            char c = chartType.charAt(i);
            if (Character.isUpperCase(c)) {
                buffer.append("_");
                buffer.append(Character.toLowerCase(c));
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String transformBack(String chartType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Character.toUpperCase(chartType.charAt(0)));
        int i = 1;
        while (i < chartType.length()) {
            char c = chartType.charAt(i);
            if (c == '_') {
                c = chartType.charAt(++i);
                buffer.append(Character.toUpperCase(c));
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String getChartType() {
        String chartType = this.mObject.getChartType().toString();
        if (chartType != null && chartType.length() > 0) {
            return this.transformBack(chartType);
        }
        return "";
    }

    private String getDimension() {
        String dimension = this.mObject.getDimension().toString();
        if (dimension != null && dimension.length() > 0) {
            return new String(new char[]{dimension.charAt(0)}).toUpperCase() + dimension.substring(1);
        }
        return "";
    }

    public void setFocus() {
        if (this.mWebControlSite != null) {
            this.mWebControlSite.setFocus();
            this.getConvenienceProperties();
        }
    }

    public void dispose() {
        if (this.mActivated) {
            this.mWebControlSite.deactivateInPlaceClient();
            this.mActivated = false;
        }
        if (this.mChartWrapper != null) {
            this.mChartWrapper.dispose();
        }
        this.mChartWrapper = null;
    }

    public void preSave() {
    }

    public void postSave() {
    }

    public Metamodel getMetamodel() {
        if (this.mObject != null) {
            return this.mObject.getRoot().getMetamodel();
        }
        return null;
    }

    public void postRollback() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

