/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CreateDeploymentFiles
extends Task {
    private String dcName;
    private String dcVendor;
    private String dcDeployFile;
    private String tempDir;
    private boolean verbose = false;

    public void execute() throws BuildException {
        FileWriter fw;
        if (this.dcName == null) {
            this.log("[CreateDeploymentFiles] dcName is not specified");
            return;
        }
        if (this.dcVendor == null) {
            this.log("[CreateDeploymentFiles] dcVendor is not specified");
            return;
        }
        if (this.tempDir == null) {
            this.log("[CreateDeploymentFiles] temporary directory tempDir not specified");
            return;
        }
        File f = new File(this.tempDir);
        if (!f.exists()) {
            f.mkdir();
        }
        String NAME_J2EEAppDD = "j2ee-app-dd.xml";
        try {
            f = new File(this.tempDir + File.separator + "j2ee-app-dd.xml");
            FileWriter fw2 = new FileWriter(f);
            fw2.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fw2.write("<SDA>\n");
            fw2.write("   <SoftwareType>J2EE</SoftwareType>\n");
            fw2.write("   <engine-deployment-descriptor version=\"2.0\">\n");
            fw2.write("   </engine-deployment-descriptor>\n");
            fw2.write("</SDA>\n");
            fw2.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            this.log(e.toString());
        }
        String NAME_META_INF = "META-INF";
        String NAME_APPLICATION_J2EE_ENGINE = "application-j2ee-engine.xml";
        String NAME_APPLICATION = "application.xml";
        try {
            f = new File(this.tempDir + File.separator + "META-INF");
            if (!f.exists()) {
                f.mkdir();
            }
            f = new File(this.tempDir + File.separator + "META-INF" + File.separator + "application-j2ee-engine.xml");
            fw = new FileWriter(f);
            fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fw.write("<application-j2ee-engine>\n");
            fw.write("    <provider-name>");
            fw.write(this.dcVendor);
            fw.write("</provider-name>\n");
            fw.write("    <modules-additional>\n");
            fw.write("    <module>\n");
            fw.write("      <entry-name>");
            fw.write(this.dcDeployFile);
            fw.write(".jar</entry-name>\n");
            fw.write("      <container-type>metamodelrepository</container-type>\n");
            fw.write("    </module>\n");
            fw.write("    <module>\n");
            fw.write("      <entry-name>");
            fw.write(this.dcDeployFile);
            fw.write("_JMI.jar</entry-name>\n");
            fw.write("      <container-type>metamodelrepository</container-type>\n");
            fw.write("    </module>\n");
            fw.write("  </modules-additional>\n");
            fw.write("  <reference reference-type=\"weak\">\n");
            fw.write("    <reference-target provider-name=\"sap.com\" target-type=\"library\">bi~mmr~jmi</reference-target>\n");
            fw.write("  </reference>\n");
            fw.write("  <reference reference-type=\"weak\">\n");
            fw.write("    <reference-target provider-name=\"sap.com\" target-type=\"library\">bi~mmr~core</reference-target>\n");
            fw.write("  </reference>\n");
            fw.write("  <reference reference-type=\"weak\">\n");
            fw.write("    <reference-target provider-name=\"sap.com\" target-type=\"library\">bi~mmr~cwm_1.0_library</reference-target>\n");
            fw.write("  </reference>\n");
            fw.write("</application-j2ee-engine>\n");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            this.log(e.toString());
        }
        try {
            f = new File(this.tempDir + File.separator + "META-INF" + File.separator + "application.xml");
            fw = new FileWriter(f);
            fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fw.write("<application>\n");
            fw.write("  <display-name>");
            fw.write(this.dcName);
            fw.write("</display-name>\n");
            fw.write("  <description>Metamodel/Metadata of DC: ");
            fw.write(this.dcName);
            fw.write("</description>\n");
            fw.write("</application>\n");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            this.log(e.toString());
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getDcName() {
        return this.dcName;
    }

    public void setDcName(String string) {
        this.dcName = string;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String string) {
        this.tempDir = string;
    }

    public String getDcVendor() {
        return this.dcVendor;
    }

    public void setDcVendor(String string) {
        this.dcVendor = string;
    }

    public String getDcDeployFile() {
        return this.dcDeployFile;
    }

    public void setDcDeployFile(String string) {
        this.dcDeployFile = string;
    }
}

