/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import java.util.Vector;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.registry.RegistryPropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class LibraryPropertySource
extends RegistryPropertySource {
    private ILibrary library;
    public static final String P_PATH = "path";
    public static final String KEY_PATH = "RegistryView.libraryPR.path";
    public static final String KEY_EXPORTED = "RegistryView.libraryPR.exported";
    public static final String KEY_FULLY_EXPORTED = "RegistryView.libraryPR.fullyExported";
    public static final String P_EXPORTED = "exported";
    public static final String P_FULLY_EXPORTED = "fully_exported";

    public LibraryPropertySource(ILibrary library) {
        this.library = library;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Vector<PropertyDescriptor> result = new Vector<PropertyDescriptor>();
        result.addElement(new PropertyDescriptor((Object)P_PATH, PDERuntimePlugin.getResourceString(KEY_PATH)));
        result.addElement(new PropertyDescriptor((Object)P_EXPORTED, PDERuntimePlugin.getResourceString(KEY_EXPORTED)));
        result.addElement(new PropertyDescriptor((Object)P_FULLY_EXPORTED, PDERuntimePlugin.getResourceString(KEY_FULLY_EXPORTED)));
        return this.toDescriptorArray(result);
    }

    public Object getPropertyValue(Object name) {
        if (name.equals(P_PATH)) {
            return this.library.getPath().toString();
        }
        if (name.equals(P_EXPORTED)) {
            return this.library.isExported() ? "true" : "false";
        }
        if (name.equals(P_FULLY_EXPORTED)) {
            return this.library.isFullyExported() ? "true" : "false";
        }
        return null;
    }
}

