/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.swt.graphics.Image;

public class LogViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image infoImage;
    private Image errorImage = PDERuntimePluginImages.DESC_ERROR_ST_OBJ.createImage();
    private Image warningImage = PDERuntimePluginImages.DESC_WARNING_ST_OBJ.createImage();

    public LogViewLabelProvider() {
        this.infoImage = PDERuntimePluginImages.DESC_INFO_ST_OBJ.createImage();
    }

    public void dispose() {
        this.errorImage.dispose();
        this.infoImage.dispose();
        this.warningImage.dispose();
        super.dispose();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        LogEntry entry = (LogEntry)((Object)element);
        if (columnIndex == 1 && !entry.isOK()) {
            switch (entry.getSeverity()) {
                case 1: {
                    return this.infoImage;
                }
                case 2: {
                    return this.warningImage;
                }
                case 4: {
                    return this.errorImage;
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        LogEntry entry = (LogEntry)((Object)element);
        switch (columnIndex) {
            case 1: {
                break;
            }
            case 2: {
                return entry.getMessage();
            }
            case 3: {
                return entry.getPluginId();
            }
            case 4: {
                return entry.getDate();
            }
        }
        return "";
    }
}

