/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.pde.internal.runtime.logview.LogReader;
import org.eclipse.pde.internal.runtime.logview.LogSession;
import org.eclipse.pde.internal.runtime.logview.LogViewContentProvider;
import org.eclipse.pde.internal.runtime.logview.LogViewLabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public class LogView
extends ViewPart
implements ILogListener {
    private TableTreeViewer tableTreeViewer;
    private ArrayList logs = new ArrayList();
    private static final String C_SEVERITY = "LogView.column.severity";
    private static final String KEY_PROPERTIES_TOOLTIP = "LogView.properties.tooltip";
    private static final String KEY_CLEAR_LABEL = "LogView.clear.label";
    private static final String KEY_CLEAR_TOOLTIP = "LogView.clear.tooltip";
    private static final String KEY_READ_LOG_LABEL = "LogView.readLog.label";
    private static final String KEY_READ_LOG_TOOLTIP = "LogView.readLog.tooltip";
    private static final String C_MESSAGE = "LogView.column.message";
    private static final String C_PLUGIN = "LogView.column.plugin";
    private static final String C_DATE = "LogView.column.date";
    private Action propertiesAction;
    private Action clearAction;
    private Action copyAction;
    private Action readLogAction;
    private Action deleteLogAction;
    private LogSession thisSession = new LogSession();
    private Clipboard clipboard;
    static /* synthetic */ Class class$0;

    public LogView() {
        this.thisSession.createSessionData();
    }

    public void createPartControl(Composite parent) {
        TableTree tableTree = new TableTree(parent, 65536);
        TableLayout tlayout = new TableLayout();
        Table table = tableTree.getTable();
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText("");
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(PDERuntimePlugin.getResourceString(C_SEVERITY));
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(PDERuntimePlugin.getResourceString(C_MESSAGE));
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(PDERuntimePlugin.getResourceString(C_PLUGIN));
        tableColumn = new TableColumn(table, 0);
        tableColumn.setText(PDERuntimePlugin.getResourceString(C_DATE));
        ColumnPixelData cLayout = new ColumnPixelData(21);
        tlayout.addColumnData((ColumnLayoutData)cLayout);
        cLayout = new ColumnPixelData(20);
        tlayout.addColumnData((ColumnLayoutData)cLayout);
        cLayout = new ColumnWeightData(100, true);
        tlayout.addColumnData((ColumnLayoutData)cLayout);
        cLayout = new ColumnPixelData(100);
        tlayout.addColumnData((ColumnLayoutData)cLayout);
        cLayout = new ColumnPixelData(100);
        tlayout.addColumnData((ColumnLayoutData)cLayout);
        table.setLayout((Layout)tlayout);
        table.setHeaderVisible(true);
        this.tableTreeViewer = new TableTreeViewer(tableTree);
        this.tableTreeViewer.setContentProvider((IContentProvider)new LogViewContentProvider(this));
        this.tableTreeViewer.setLabelProvider((IBaseLabelProvider)new LogViewLabelProvider());
        this.tableTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                LogView.this.handleSelectionChanged(e.getSelection());
            }
        });
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                LogView.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Menu menu = popupMenuManager.createContextMenu((Control)tableTree);
        tableTree.setMenu(menu);
        this.readLogFile();
        Platform.addLogListener((ILogListener)this);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.Platform");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.tableTreeViewer.setInput((Object)clazz);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableTreeViewer);
        this.propertiesAction = new PropertyDialogAction(table.getShell(), (ISelectionProvider)this.tableTreeViewer);
        this.propertiesAction.setImageDescriptor(PDERuntimePluginImages.DESC_PROPERTIES);
        this.propertiesAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_PROPERTIES_DISABLED);
        this.propertiesAction.setHoverImageDescriptor(PDERuntimePluginImages.DESC_PROPERTIES_HOVER);
        this.propertiesAction.setToolTipText(PDERuntimePlugin.getResourceString(KEY_PROPERTIES_TOOLTIP));
        this.propertiesAction.setEnabled(false);
        this.clearAction = new Action(PDERuntimePlugin.getResourceString(KEY_CLEAR_LABEL)){

            public void run() {
                LogView.this.handleClear();
            }
        };
        this.clearAction.setImageDescriptor(PDERuntimePluginImages.DESC_CLEAR);
        this.clearAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_CLEAR_DISABLED);
        this.clearAction.setHoverImageDescriptor(PDERuntimePluginImages.DESC_CLEAR_HOVER);
        this.clearAction.setToolTipText(PDERuntimePlugin.getResourceString(KEY_CLEAR_TOOLTIP));
        this.clearAction.setText(PDERuntimePlugin.getResourceString(KEY_CLEAR_LABEL));
        this.readLogAction = new Action(PDERuntimePlugin.getResourceString(KEY_READ_LOG_LABEL)){

            public void run() {
                LogView.this.restoreFromFile();
            }
        };
        this.readLogAction.setToolTipText(PDERuntimePlugin.getResourceString(KEY_READ_LOG_TOOLTIP));
        this.readLogAction.setImageDescriptor(PDERuntimePluginImages.DESC_READ_LOG);
        this.readLogAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_READ_LOG_DISABLED);
        this.readLogAction.setHoverImageDescriptor(PDERuntimePluginImages.DESC_READ_LOG_HOVER);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!LogView.this.tableTreeViewer.getSelection().isEmpty()) {
                    LogView.this.propertiesAction.run();
                }
            }
        });
        this.deleteLogAction = new Action(PDERuntimePlugin.getResourceString("LogView.delete")){

            public void run() {
                LogView.this.doDeleteLog();
            }
        };
        this.deleteLogAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.delete.tooltip"));
        this.copyAction = new Action(PDERuntimePlugin.getResourceString("LogView.copy")){

            public void run() {
                LogView.this.copyToClipboard(LogView.this.tableTreeViewer.getSelection());
            }
        };
        this.copyAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setHoverImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_HOVER"));
        this.deleteLogAction.setImageDescriptor(PDERuntimePluginImages.DESC_REMOVE_LOG);
        this.deleteLogAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_REMOVE_LOG_DISABLED);
        this.deleteLogAction.setHoverImageDescriptor(PDERuntimePluginImages.DESC_REMOVE_LOG_HOVER);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler("properties", (IAction)this.propertiesAction);
        bars.setGlobalActionHandler("copy", (IAction)this.copyAction);
        IToolBarManager toolBarManager = bars.getToolBarManager();
        toolBarManager.add((IAction)this.deleteLogAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.clearAction);
        toolBarManager.add((IAction)this.readLogAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.propertiesAction);
        WorkbenchHelp.setHelp((Control)tableTree, (String)"org.eclipse.pde.doc.user.log_view");
        this.clipboard = new Clipboard(tableTree.getDisplay());
    }

    public void dispose() {
        Platform.removeLogListener((ILogListener)this);
        this.clipboard.dispose();
        super.dispose();
    }

    private void doDeleteLog() {
        File logFile = Platform.getLogFileLocation().toFile();
        if (logFile.exists()) {
            String title = PDERuntimePlugin.getResourceString("LogView.confirmDelete.title");
            String message = PDERuntimePlugin.getResourceString("LogView.confirmDelete.message");
            if (!MessageDialog.openConfirm((Shell)this.tableTreeViewer.getControl().getShell(), (String)title, (String)message)) {
                return;
            }
            logFile.delete();
            this.logs.clear();
            this.tableTreeViewer.refresh();
        }
    }

    public void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.readLogAction);
        manager.add((IAction)this.clearAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.copyAction);
        manager.add((IAction)this.deleteLogAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.propertiesAction);
    }

    public LogEntry[] getLogs() {
        return this.logs.toArray(new LogEntry[this.logs.size()]);
    }

    public TableTreeViewer getTableTreeViewer() {
        return this.tableTreeViewer;
    }

    protected void handleClear() {
        BusyIndicator.showWhile((Display)this.tableTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                LogView.this.logs.clear();
                LogView.this.tableTreeViewer.refresh();
            }
        });
    }

    protected void restoreFromFile() {
        BusyIndicator.showWhile((Display)this.tableTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                LogView.this.readLogFile();
                LogView.this.tableTreeViewer.refresh();
            }
        });
    }

    private void readLogFile() {
        this.logs.clear();
        File logFile = Platform.getLogFileLocation().toFile();
        if (!logFile.exists()) {
            return;
        }
        LogReader.parseLogFile(logFile, this.logs);
    }

    public void logging(IStatus status) {
        this.pushStatus(status);
    }

    public void logging(IStatus status, String plugin) {
        this.pushStatus(status);
    }

    private void pushStatus(IStatus status) {
        LogEntry entry = new LogEntry(status);
        entry.setSession(this.thisSession);
        this.logs.add(0, entry);
        this.asyncRefresh();
    }

    private void asyncRefresh() {
        final Control control = this.tableTreeViewer.getControl();
        if (control.isDisposed()) {
            return;
        }
        Display display = control.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!control.isDisposed()) {
                        LogView.this.tableTreeViewer.refresh();
                    }
                }
            });
        }
    }

    public void setFocus() {
        this.tableTreeViewer.getTableTree().getTable().setFocus();
    }

    private void handleSelectionChanged(ISelection selection) {
        this.propertiesAction.setEnabled(!selection.isEmpty());
        this.updateStatus(selection);
        this.copyAction.setEnabled(!selection.isEmpty());
    }

    private void updateStatus(ISelection selection) {
        IStatusLineManager status = this.getViewSite().getActionBars().getStatusLineManager();
        if (selection.isEmpty()) {
            status.setMessage(null);
        } else {
            LogEntry entry = (LogEntry)((Object)((IStructuredSelection)selection).getFirstElement());
            LogViewLabelProvider provider = (LogViewLabelProvider)this.getTableTreeViewer().getLabelProvider();
            status.setMessage(provider.getColumnText((Object)entry, 2));
        }
    }

    private void copyToClipboard(ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        ssel.toArray();
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        if (selection.isEmpty()) {
            return;
        }
        LogEntry entry = (LogEntry)((Object)((IStructuredSelection)selection).getFirstElement());
        entry.write(pwriter);
        pwriter.flush();
        String textVersion = writer.toString();
        try {
            pwriter.close();
            writer.close();
        }
        catch (IOException iOException) {}
        this.clipboard.setContents(new Object[]{textVersion}, new Transfer[]{TextTransfer.getInstance()});
    }
}

