/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.internal.runtime.logview.LineReader;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.pde.internal.runtime.logview.LogSession;

class LogReader {
    private static final int SESSION_STATE = 10;
    private static final int ENTRY_STATE = 20;
    private static final int SUBENTRY_STATE = 30;
    private static final int MESSAGE_STATE = 40;
    private static final int STACK_STATE = 50;
    private static final int TEXT_STATE = 60;
    private static final int UNKNOWN_STATE = 70;

    LogReader() {
    }

    public static void parseLogFile(File file, ArrayList entries) {
        List lines = LogReader.load(file);
        LogReader.parse(lines, entries);
    }

    private static List load(File file) {
        List lines = null;
        FileInputStream is = null;
        try {
            try {
                is = new FileInputStream(file);
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF8"));
                lines = new LineReader(reader).readLines();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        Object var4_6 = null;
        if (is != null) {
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
        }
        if (lines == null) {
            lines = new ArrayList();
        }
        return lines;
    }

    private static LogEntry[] parse(List lines, ArrayList entries) {
        ArrayList parents = new ArrayList();
        LogEntry current = null;
        LogSession session = null;
        int writerState = 70;
        StringWriter swriter = null;
        PrintWriter writer = null;
        int state = 70;
        int i = 0;
        while (i < lines.size()) {
            block21: {
                LogEntry entry;
                String line;
                block20: {
                    line = (String)lines.get(i);
                    state = (line = line.trim()).startsWith("!SESSION") ? 10 : (line.startsWith("!ENTRY") ? 20 : (line.startsWith("!SUBENTRY") ? 30 : (line.startsWith("!MESSAGE") ? 40 : (line.startsWith("!STACK") ? 50 : 60))));
                    if (state != 60) break block20;
                    if (writer != null) {
                        writer.println(line);
                    }
                    if (i < lines.size() - 1) break block21;
                }
                if (writer != null) {
                    if (writerState == 50 && current != null) {
                        current.setStack(swriter.toString());
                    } else if (writerState == 10 && session != null) {
                        session.setSessionData(swriter.toString());
                    }
                    writerState = 70;
                    swriter = null;
                    writer.close();
                    writer = null;
                }
                if (state == 50) {
                    swriter = new StringWriter();
                    writer = new PrintWriter((Writer)swriter, true);
                    writerState = 50;
                } else if (state == 10) {
                    session = new LogSession();
                    swriter = new StringWriter();
                    writer = new PrintWriter((Writer)swriter, true);
                    writerState = 10;
                } else if (state == 20) {
                    entry = new LogEntry();
                    entry.setSession(session);
                    entry.processLogLine(line, true);
                    LogReader.setNewParent(parents, entry, 0);
                    current = entry;
                    entries.add(0, entry);
                } else if (state == 30) {
                    entry = new LogEntry();
                    entry.setSession(session);
                    int depth = entry.processLogLine(line, false);
                    LogReader.setNewParent(parents, entry, depth);
                    current = entry;
                    LogEntry parent = (LogEntry)((Object)parents.get(depth - 1));
                    parent.addChild(entry);
                } else if (state == 40) {
                    String message = "";
                    if (line.length() > 8) {
                        message = line.substring(9);
                    }
                    if (current != null) {
                        current.setMessage(message);
                    }
                }
            }
            ++i;
        }
        return entries.toArray(new LogEntry[entries.size()]);
    }

    private static void setNewParent(ArrayList parents, LogEntry entry, int depth) {
        if (depth + 1 > parents.size()) {
            parents.add(entry);
        } else {
            parents.set(depth, entry);
        }
    }
}

