/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.report;

import com.togethersoft.sca.core.IAnalyzerCategory;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IParameterRegistry;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.core.plugin.report.IMessageFilter;
import com.togethersoft.sca.core.plugin.report.IReportMessage;
import com.togethersoft.sca.core.plugin.report.IReporter;
import com.togethersoft.sca.core.plugin.report.MessageList;
import com.togethersoft.sca.internal.plugin.report.Messages;
import com.togethersoft.sca.internal.plugin.report.PieChart;
import com.togethersoft.sca.internal.plugin.report.XMLReport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import sun.io.CharToByteConverter;

public class SummaryReport
extends XMLReport
implements IReporter {
    private String statisticsFileName;
    private String diagramFileName;
    private String perProjectListName;
    private String perPackageListName;
    private String perFileListName;
    private String perClassListName;
    private String perMethodListName;
    private String perAuditListName;
    private String structuralReportName;
    private String legendFileName;
    private PrintWriter statistics;
    private PrintWriter diagram;
    private PrintWriter perProjectList;
    private PrintWriter perPackageList;
    private PrintWriter perFileList;
    private PrintWriter perClassList;
    private PrintWriter perMethodList;
    private PrintWriter perAuditList;
    private PrintWriter structuralReport;
    private PrintWriter legend;
    private int auditIdCounter;
    private int locationIdCounter;
    private static CharToByteConverter ctb;

    public String name() {
        return "SummaryReport";
    }

    public String description() {
        return "Provides summary report";
    }

    public String[] analyzersRequired() {
        return new String[]{"Audit", "DetectAudit"};
    }

    public IMessageFilter[] filtersRequired() {
        return new IMessageFilter[0];
    }

    public IParameterRegistry getParameterRegistry() {
        return null;
    }

    private void sortMessages(IReportMessage[] in, int nElems) {
        Comparator cmp = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                IReportMessage m1 = (IReportMessage)obj1;
                IReportMessage m2 = (IReportMessage)obj2;
                int rc = m1.getFileName().compareTo(m2.getFileName());
                if (rc == 0 && (rc = m1.getStartLine() - m2.getStartLine()) == 0) {
                    rc = m1.getStartColumn() - m2.getStartColumn();
                }
                return -rc;
            }
        };
        Arrays.sort(in, 0, nElems, cmp);
    }

    private void buildStringTable(StringNameTable t, IReportMessage[] in, int nElems) {
        int i = 0;
        while (i < nElems) {
            IReportMessage mess = in[i];
            String s = mess.getProblemSeverity();
            if (s != null) {
                t.add(mess.getProblemSeverity());
            } else {
                System.err.println("SEVERITY == null");
                System.err.println(mess.getMessage());
            }
            ++i;
        }
    }

    private void printReportHeader(PrintWriter out, String title, String projectName) {
        out.println("<HTML>");
        out.println("<HEAD>");
        out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        out.println("<TITLE>" + title + "</TITLE>");
        out.println("</HEAD>");
        out.println("<BODY>");
        out.println("<FONT FACE=\"arial\">");
        out.println("<H1>" + title + "</H1>");
        out.println("<b>" + Messages.getString("SummaryReport.Project.text") + ":\t</b>" + projectName + "<br>");
        out.println("<b>" + Messages.getString("SummaryReport.Report_Generated_on.text") + ": </b>" + new Date());
    }

    private void printTableOfContents(PrintWriter out) {
        out.println("<H2>" + Messages.getString("SummaryReport.Table_of_Contents.text") + "</H2>");
        out.println("<li><a href=\"" + this.statisticsFileName + "\">" + Messages.getString("SummaryReport.Audit_Statistics.text") + "</a></li>");
        out.println("<ul>");
        out.println("<li><a href=\"" + this.statisticsFileName + "#project_statistics\">" + Messages.getString("SummaryReport.Project_Statistics.text") + "</a></li><br>");
        out.println("<li><a href=\"" + this.statisticsFileName + "#package_statistics\">" + Messages.getString("SummaryReport.Package_Statistics.text") + "</a></li><br>");
        out.println("<li><a href=\"" + this.statisticsFileName + "#class_statistics\">" + Messages.getString("SummaryReport.Class_Statistics.text") + "</a></li><br>");
        out.println("<li><a href=\"" + this.statisticsFileName + "#file_statistics\">" + Messages.getString("SummaryReport.File_Statistics.text") + "</a></li><br>");
        out.println("<li><a href=\"" + this.statisticsFileName + "#method_statistics\">" + Messages.getString("SummaryReport.Method_Statistics.text") + "</a></li><br>");
        out.println("<li><a href=\"" + this.statisticsFileName + "#audit_categories\">" + Messages.getString("SummaryReport.Audit_Category_Statistics.text") + "</a></li><br>");
        out.println("</ul>");
        out.println("</b>");
        out.println("</ul>");
    }

    public void generate(File reportFile, PrintStream out0, MessageList inList, String theProjectName, JobControl jobControl) {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)out0, "UTF-8"));
        }
        catch (IOException ioe) {
            out0.println(ioe);
        }
        IReportMessage[] in = inList.asArray();
        int nElems = inList.elementsUsed();
        this.sortMessages(in, nElems);
        MessageLocationInfo locations = new MessageLocationInfo();
        MessageCategoryInfo cls = new MessageCategoryInfo();
        StringNameTable t = new StringNameTable();
        this.buildStringTable(t, in, nElems);
        if (t.t == null) {
            return;
        }
        MessageLocationInfo.access$102(locations, new int[t.t.length]);
        int i = 0;
        while (i < nElems) {
            IReportMessage mess = in[i];
            this.addLocationInfo(locations, mess, t);
            this.addClassInfo(cls, mess);
            if (jobControl != null) {
                jobControl.update((double)nElems / 100.0);
            }
            ++i;
        }
        locations.updateCounters();
        cls.updateCounters();
        this.buildFileNamesAndOpenFiles(reportFile);
        if (theProjectName == null) {
            int n = locations.countNodes(1);
            MessageLocationInfo[] locs = new MessageLocationInfo[n];
            locations.toArray(locs, 0, 1);
            theProjectName = "";
            int i2 = 0;
            while (i2 < locs.length) {
                if (i2 > 0) {
                    theProjectName = theProjectName + ", ";
                }
                theProjectName = theProjectName + locs[i2].getObjectName();
                ++i2;
            }
        }
        boolean includePieChart = locations.countNodes(2) > 1;
        this.printReportHeader(out, Messages.getString("SummaryReport.QA_Report.text"), theProjectName);
        this.printOverviewReport(reportFile, out, cls, locations, includePieChart);
        this.printTableOfContents(out);
        locations.printSubstructures(out);
        this.structuralReport.println("<HTML>");
        this.structuralReport.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        this.structuralReport.println("<BODY>");
        locations.printSubstructures1(this.structuralReport);
        this.structuralReport.println("</BODY>");
        this.structuralReport.println("</HTML>");
        this.printStatisticsHeader(this.statistics);
        locations.printStatistics(this.statistics, t);
        this.statistics.println("<H2><a name=\"audit_categories\">" + Messages.getString("SummaryReport.Audit_Category_Statistics.text") + "</a></H2>");
        this.perAuditList.println("<HTML>");
        this.perAuditList.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        this.perAuditList.println("<BODY>");
        cls.printStatistics(this.statistics, this.perAuditListName, this.perAuditList);
        this.perAuditList.println("</BODY>");
        this.perAuditList.println("</HTML>");
        this.statistics.println("</BODY>");
        this.statistics.println("</HTML>");
        out.println("</BODY>");
        out.println("</HTML>");
        this.printLegend();
        this.closeFiles();
        out.close();
    }

    private void printLegend() {
        this.legend.println("<html>");
        this.legend.println("<title>" + Messages.getString("SummaryReport.Legend.text") + "</title>");
        this.legend.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        this.legend.println("<body>");
        this.legend.println("<h1>" + Messages.getString("SummaryReport.Message_severity_types.text") + "</h1>");
        this.legend.println("<p>" + Messages.getString("SummaryReport.Each_audit_message.text") + "</p>");
        this.legend.println("<dl>");
        this.legend.println("<p><dt><b>" + Messages.getString("SummaryReport.Fatal.text") + "</b></dt><dd>");
        this.legend.println(Messages.getString("SummaryReport.These_will_cause.text"));
        this.legend.println("</dd></p>");
        this.legend.println("<p><dt><b>" + Messages.getString("SummaryReport.Error.text") + "</b></dt><dd>");
        this.legend.println(Messages.getString("SummaryReport.Errors_are_either.text"));
        this.legend.println("</dd></p>");
        this.legend.println("<p><dt><b>" + Messages.getString("SummaryReport.Warning.text") + "</b></dt><dd>");
        this.legend.println(Messages.getString("SummaryReport.Warnings_point_to_source.text"));
        this.legend.println("</dd></p>");
        this.legend.println("<p><dt><b>" + Messages.getString("SummaryReport.Info.text") + "</b></dt><dd>");
        this.legend.println(Messages.getString("SummaryReport.Info_messages_tell.text"));
        this.legend.println("</dd></p></dl>");
        this.legend.println("</body></html>");
    }

    private void printStatisticsHeader(PrintWriter out) {
        out.println("<html>");
        out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        out.println("<title>" + Messages.getString("SummaryReport.Statistical_Report.text") + "</title>");
        out.println("<body>");
    }

    private int detectSeriousProblems(MessageClassInfo[] problems, MessageCategoryInfo cls) {
        MessageClassInfo[] ci = new MessageClassInfo[this.auditIdCounter];
        int nInfo = cls.listSeriousAudits(0, ci);
        Comparator cmp = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                MessageClassInfo m1 = (MessageClassInfo)obj1;
                MessageClassInfo m2 = (MessageClassInfo)obj2;
                return m2.counter - m1.counter;
            }
        };
        Arrays.sort(ci, 0, nInfo, cmp);
        if (nInfo > problems.length) {
            nInfo = problems.length;
        }
        int i = 0;
        while (i < nInfo) {
            problems[i] = ci[i];
            ++i;
        }
        return nInfo;
    }

    private void printOverviewReport(File reportFile, PrintWriter out, MessageCategoryInfo cls, MessageLocationInfo locations, boolean includePieChart) {
        MessageClassInfo[] problems = new MessageClassInfo[5];
        out.println("<H2><A NAME=\"overview\">" + Messages.getString("SummaryReport.Overview.text") + "</A></H2>");
        out.println("<H3><A NAME=\"serious\">" + Messages.getString("SummaryReport.Top_5_Audit_Problems.text") + "</A></H3>");
        int nProblems = this.detectSeriousProblems(problems, cls);
        if (nProblems != 0) {
            int i = 0;
            while (i < nProblems) {
                problems[i].printStatistics(out, this.perAuditListName, 1);
                ++i;
            }
        } else {
            out.println(Messages.getString("SummaryReport.No_serious_problems_detected.text"));
        }
        if (includePieChart) {
            locations.printTopProblemPackages(reportFile, out);
        }
    }

    private void addLocationInfo(MessageLocationInfo root, IReportMessage mess, StringNameTable t) {
        MessageLocationInfo l = root;
        int tl = t.t.length;
        if (mess.getProjectName() != null) {
            MessageLocation projectObject = new MessageLocation(mess.getProjectName(), 0);
            l = l.addSubLocation(projectObject, tl);
        }
        if (mess.getPackageName() != null) {
            MessageLocation packageObject = new MessageLocation(mess.getPackageName(), 7);
            l = l.addSubLocation(packageObject, tl);
        }
        if (mess.getCompilationUnitName() != null) {
            MessageLocation fileObject = new MessageLocation(mess.getCompilationUnitName(), 1);
            l = l.addSubLocation(fileObject, tl);
        }
        if (mess.getTypeName() != null) {
            MessageLocation classObject = new MessageLocation(mess.getTypeName(), 8);
            l = l.addSubLocation(classObject, tl);
        }
        if (mess.getMethodName() != null) {
            MessageLocation methodObject = new MessageLocation(mess.getMethodName(), 6);
            l = l.addSubLocation(methodObject, tl);
        }
        MessageReference mr = new MessageReference(mess, l.mList);
        l.mList = mr;
        l.counter += 1;
        int[] nArray = l.counters;
        int n = t.asIdx(mess.getProblemSeverity());
        nArray[n] = nArray[n] + 1;
    }

    private void addClassInfo(MessageCategoryInfo root, IReportMessage mess) {
        IAnalyzerDescriptor analyzer = mess.getAnalyzer();
        if (analyzer != null) {
            MessageClassInfo mci = null;
            MessageCategoryInfo info = root.find(analyzer.getCategory());
            MessageClassInfo c = info.cls;
            while (c != null) {
                if (c.analyzer == analyzer) {
                    mci = c;
                    break;
                }
                c = c.next;
            }
            if (mci == null) {
                mci = new MessageClassInfo(info, analyzer);
            }
            mci.counter += 1;
            MessageReference mr = new MessageReference(mess, mci.mr);
            mci.mr = mr;
        } else {
            System.err.println("analyzer == null");
            System.err.println(mess.getMessage());
        }
    }

    private void printMessage(PrintWriter out, MessageReference mlist, boolean header, boolean link) {
        if (mlist != null) {
            if (header) {
                out.println("<tr><td width=50%><b>" + Messages.getString("SummaryReport.Message.text") + "</b></td><td><b>" + Messages.getString("SummaryReport.Location.text") + "<b></td></tr>");
            }
            MessageReference mr = mlist;
            while (mr != null) {
                this.printMessage(out, mr.msg, link, 0);
                mr = mr.ref;
            }
        }
    }

    private void printMessage(PrintWriter out, IReportMessage msg, boolean link, int level) {
        String loc = !"".equals(msg.getFileName()) ? msg.getFileName() + ":" + msg.getStartLine() + ":" + msg.getStartColumn() : "";
        String message = link ? SummaryReport.getLinkToAudit(msg.getAnalyzer(), msg.getMessage()) : msg.getMessage();
        out.println("<TR><TD>");
        if (level > 0) {
            out.print("<IMG SRC=\"blank\" WIDTH=" + 20 * level + " HEIGHT=1>");
        }
        out.print(message);
        out.println("</TD><TD>" + loc + "</TD></TR>");
        IReportMessage[] subMessages = msg.getSubMessages();
        if (subMessages != null) {
            int i = 0;
            while (i < subMessages.length) {
                this.printMessage(out, subMessages[i], link, level + 1);
                ++i;
            }
        }
    }

    public static String getLinkToAudit(IAnalyzerDescriptor analyzer, String name) {
        String doc = analyzer.getInspector().find("docs/" + analyzer.getId() + ".html").getFile();
        return "<a href=\"" + doc + "\">" + name + "</a>";
    }

    private String buildFileName(File reportFile, String suffix) {
        String resultFileName = reportFile.getName();
        int k = resultFileName.lastIndexOf(46);
        resultFileName = k >= 0 ? resultFileName.substring(0, k) + suffix : resultFileName + suffix;
        return resultFileName;
    }

    private PrintWriter openExtensionStream(File reportFile, String name) {
        PrintWriter result;
        try {
            File resultFile = new File(reportFile.getParentFile(), name);
            result = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resultFile), "UTF-8"));
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    private void buildFileNamesAndOpenFiles(File reportFile) {
        this.statisticsFileName = this.buildFileName(reportFile, "_statistics.html");
        this.diagramFileName = this.buildFileName(reportFile, "_diagram.svg");
        this.perProjectListName = this.buildFileName(reportFile, "_projects.html");
        this.perPackageListName = this.buildFileName(reportFile, "_packages.html");
        this.perFileListName = this.buildFileName(reportFile, "_files.html");
        this.perClassListName = this.buildFileName(reportFile, "_classes.html");
        this.perMethodListName = this.buildFileName(reportFile, "_methods.html");
        this.perAuditListName = this.buildFileName(reportFile, "_audit.html");
        this.structuralReportName = this.buildFileName(reportFile, "_structure.html");
        this.legendFileName = this.buildFileName(reportFile, "_legend.html");
        this.statistics = this.openExtensionStream(reportFile, this.statisticsFileName);
        this.diagram = this.openExtensionStream(reportFile, this.diagramFileName);
        this.perProjectList = this.openExtensionStream(reportFile, this.perProjectListName);
        this.perPackageList = this.openExtensionStream(reportFile, this.perPackageListName);
        this.perFileList = this.openExtensionStream(reportFile, this.perFileListName);
        this.perClassList = this.openExtensionStream(reportFile, this.perClassListName);
        this.perMethodList = this.openExtensionStream(reportFile, this.perMethodListName);
        this.perAuditList = this.openExtensionStream(reportFile, this.perAuditListName);
        this.structuralReport = this.openExtensionStream(reportFile, this.structuralReportName);
        this.legend = this.openExtensionStream(reportFile, this.legendFileName);
    }

    private void closeFiles() {
        try {
            this.statistics.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.diagram.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.perProjectList.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.perPackageList.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.perFileList.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.perClassList.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.perMethodList.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.perAuditList.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.structuralReport.close();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.legend.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            ctb = CharToByteConverter.getConverter((String)"UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private class MessageLocationInfo {
        private MessageLocation location;
        private int counter;
        private int[] counters;
        private int id;
        private MessageReference mList;
        private MessageLocationInfo next;
        private MessageLocationInfo sub;
        private MessageLocationInfo up;
        final int ctxProject = 1;
        final int ctxPackage = 2;
        final int ctxFile = 4;
        final int ctxClass = 8;
        final int ctxMethod = 16;

        MessageLocationInfo addSubLocation(MessageLocation key, int tl) {
            MessageLocationInfo s = this.sub;
            while (s != null) {
                if (s.location.equals(key)) {
                    return s;
                }
                s = s.next;
            }
            return new MessageLocationInfo(key, this, tl);
        }

        MessageLocationInfo(MessageLocation location, MessageLocationInfo up, int tl) {
            this.location = location;
            this.up = up;
            this.next = up.sub;
            up.sub = this;
            this.counters = new int[tl];
            this.id = SummaryReport.this.locationIdCounter;
            SummaryReport.this.locationIdCounter += 1;
        }

        MessageLocationInfo() {
            this.id = SummaryReport.this.locationIdCounter;
            SummaryReport.this.locationIdCounter += 1;
        }

        void updateCounters() {
            MessageLocationInfo s = this.sub;
            while (s != null) {
                s.updateCounters();
                this.counter += s.counter;
                int i = 0;
                while (i < this.counters.length) {
                    int n = i;
                    this.counters[n] = this.counters[n] + s.counters[i];
                    ++i;
                }
                s = s.next;
            }
        }

        void printTopProblemPackages(File reportFile, PrintWriter out) {
            int n = this.countNodes(2);
            MessageLocationInfo[] locs = new MessageLocationInfo[n];
            this.toArray(locs, 0, 2);
            Arrays.sort(locs, new Comparator(this){
                private final /* synthetic */ MessageLocationInfo this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object o1, Object o2) {
                    MessageLocationInfo ml1 = (MessageLocationInfo)o1;
                    MessageLocationInfo ml2 = (MessageLocationInfo)o2;
                    return MessageLocationInfo.access$900(ml2) - MessageLocationInfo.access$900(ml1);
                }
            });
            if (n > 1) {
                out.println("<H3><a name=\"piechart\">" + Messages.getString("SummaryReport.Distribution_of_Audits_across.text") + "</a></H3>");
                int count = n < 10 ? n : 10;
                int[] val = new int[count];
                String[] id = new String[count];
                int i = 0;
                while (i < count) {
                    val[i] = locs[i].counter;
                    id[i] = locs[i].location.astObjectName.replace('/', '.');
                    ++i;
                }
                out.println("<embed src=\"" + SummaryReport.this.diagramFileName + "\" width=\"800\" height=\"350\" " + "pluginspage=\"http://www.adobe.com/svg/viewer/install/\">");
                new PieChart().printChart(SummaryReport.this.diagram, val, id);
            }
        }

        void printStatistics(PrintWriter out, StringNameTable t) {
            out.println("<h2><a name=\"statistics\">" + Messages.getString("SummaryReport.Audit_Statistics.text") + "</a></h2>");
            this.printStatistics("<A NAME=\"project_statistics\">" + Messages.getString("SummaryReport.Project_statistics.text") + "</A>", t, out, SummaryReport.this.perProjectListName, 1, false);
            this.printStatistics(Messages.getString("SummaryReport.Per_project_statistics.text"), t, SummaryReport.this.perProjectList, SummaryReport.this.perProjectListName, 1, true);
            this.printStatistics("<A NAME=\"package_statistics\">" + Messages.getString("SummaryReport.Package_statistics.text") + "</A>", t, out, SummaryReport.this.perPackageListName, 2, false);
            this.printStatistics(Messages.getString("SummaryReport.Per_package_statistics.text"), t, SummaryReport.this.perPackageList, SummaryReport.this.perPackageListName, 2, true);
            this.printStatistics("<A NAME=\"class_statistics\">" + Messages.getString("SummaryReport.Class_statistics.text") + "</A>", t, out, SummaryReport.this.perClassListName, 8, false);
            this.printStatistics(Messages.getString("SummaryReport.Per_class_statistics.text"), t, SummaryReport.this.perClassList, SummaryReport.this.perClassListName, 8, true);
            this.printStatistics("<A NAME=\"file_statistics\">" + Messages.getString("SummaryReport.File_statistics.text") + "</A>", t, out, SummaryReport.this.perFileListName, 4, false);
            this.printStatistics(Messages.getString("SummaryReport.Per_file_statistics.text"), t, SummaryReport.this.perFileList, SummaryReport.this.perFileListName, 4, true);
            this.printStatistics("<A NAME=\"method_statistics\">" + Messages.getString("SummaryReport.Method_statistics.text") + "</A>", t, out, SummaryReport.this.perMethodListName, 16, false);
            this.printStatistics(Messages.getString("SummaryReport.Per_method_statistics.text"), t, SummaryReport.this.perMethodList, SummaryReport.this.perMethodListName, 16, true);
        }

        private void printStatistics(String header, StringNameTable t, PrintWriter out, String detailsFile, int context, boolean expand) {
            int n = this.countNodes(context);
            MessageLocationInfo[] locs = new MessageLocationInfo[n];
            this.toArray(locs, 0, context);
            Arrays.sort(locs, new Comparator(this){
                private final /* synthetic */ MessageLocationInfo this$1;
                {
                    this.this$1 = this$1;
                }

                public int compare(Object o1, Object o2) {
                    MessageLocationInfo ml1 = (MessageLocationInfo)o1;
                    MessageLocationInfo ml2 = (MessageLocationInfo)o2;
                    return MessageLocationInfo.access$900(ml2) - MessageLocationInfo.access$900(ml1);
                }
            });
            String ctxName = context == 1 ? Messages.getString("SummaryReport.Project.text") : (context == 2 ? Messages.getString("SummaryReport.Package.text") : (context == 4 ? Messages.getString("SummaryReport.File.text") : (context == 8 ? Messages.getString("SummaryReport.Class.text") : Messages.getString("SummaryReport.Method.text"))));
            if (n != 0) {
                if (!expand) {
                    out.println("<H3>" + header + "</H3>");
                    out.println("<TABLE border=1 width=100%>");
                    out.print("<TR><TH align=\"center\"><b>" + ctxName + " " + Messages.getString("SummaryReport.Name.text") + " </b></TH>" + "<TH width=10% align=\"center\" bgcolor=#c0c0c0>" + Messages.getString("SummaryReport.Total.text") + "</TH>");
                    int i = 0;
                    while (i < t.t.length) {
                        out.print("<TH width=10% align=\"center\"><b><a href=\"" + SummaryReport.this.legendFileName + "\">" + t.t[i] + "</a></b></TH>");
                        ++i;
                    }
                    out.println("</TR>");
                    int i2 = 0;
                    while (i2 < n) {
                        locs[i2].print(out, detailsFile, expand);
                        ++i2;
                    }
                    out.println("</TABLE>");
                } else {
                    out.println("<HTML>");
                    out.println("<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
                    out.println("<BODY>");
                    out.println("<UL>");
                    int i = 0;
                    while (i < n) {
                        locs[i].print(out, detailsFile, expand);
                        ++i;
                    }
                    out.println("</UL>");
                    out.println("</BODY>");
                    out.println("</HTML>");
                }
            }
        }

        private void printSubstructures(PrintWriter out) {
            if (this.sub != null) {
                if (this.location != null && this.location.astObjectKind != 1) {
                    out.println("<ul>");
                }
                MessageLocationInfo m = this.sub;
                while (m != null) {
                    m.printStructureContence(out);
                    m = m.next;
                }
                if (this.location != null && this.location.astObjectKind != 1) {
                    out.println("</ul>");
                }
            }
        }

        void printStructureContence(PrintWriter out) {
            if (this.location != null && this.location.astObjectKind != 1) {
                if (this.location.astObjectKind == 6) {
                    return;
                }
                String c = this.location.astObjectKind == 0 ? Messages.getString("SummaryReport.Project.text") + ":" : (this.location.astObjectKind == 7 ? Messages.getString("SummaryReport.Package.text") + ":" : "");
                out.println("<li><a href=\"" + SummaryReport.this.structuralReportName + "#LOC" + this.id + "\">" + c + " " + this.getObjectName() + "</a>");
            }
            this.printSubstructures(out);
        }

        private void printSubstructures1(PrintWriter out) {
            if (this.sub != null) {
                MessageLocationInfo m = this.sub;
                while (m != null) {
                    m.printStructure(out);
                    m = m.next;
                }
            }
        }

        void printStructure(PrintWriter out) {
            if (this.location != null && this.location.astObjectKind != 1) {
                String c = this.location.astObjectKind == 0 ? Messages.getString("SummaryReport.Project.text") + ":" : (this.location.astObjectKind == 7 ? Messages.getString("SummaryReport.Package.text") + ":" : (this.location.astObjectKind == 6 ? Messages.getString("SummaryReport.Method.text") + ":" : Messages.getString("SummaryReport.Class.text") + ":"));
                out.println("<table border=1 width=100%>");
                out.println("<tr>");
                out.println("<td>");
                out.println("<a name=\"#LOC" + this.id + "\"><b>" + c + " " + this.getObjectName() + "</b></a>");
                out.println("</td>");
                out.println("</tr>");
                out.println("<tr><td>");
                out.println("<table width=100%>");
                SummaryReport.this.printMessage(out, this.mList, true, true);
                out.println("</table>");
                out.println("</td></tr>");
                out.println("</table>");
                out.println("<p>");
            }
            this.printSubstructures1(out);
        }

        private String getObjectName() {
            String nm = null;
            nm = this.location.astObjectName != null ? this.location.astObjectName.replace('/', '.') : "[" + Messages.getString("SummaryReport.Project_Name.text") + "]";
            return nm;
        }

        private void print(PrintWriter out, String detailsFile, boolean expand) {
            if (this.location == null) {
                return;
            }
            String nm = this.getObjectName();
            if (nm != null) {
                if (!expand) {
                    out.print("<TR><TH ALIGN=LEFT><A href=\"" + detailsFile + "#LOC" + this.id + "\">" + nm + "</A></TH>" + "<TD  width=10% align=\"center\" bgcolor=#c0c0c0>" + this.counter + "</TD>");
                    int i = 0;
                    while (i < this.counters.length) {
                        out.print("<TD width=10% align=\"center\">" + this.counters[i] + "</TD>");
                        ++i;
                    }
                    out.println("</TR>");
                } else {
                    out.print("<LI><A NAME=LOC" + this.id + ">" + nm + "</A>");
                    out.println("<UL>");
                    this.printMessages(out, true);
                    out.println("</UL>");
                }
            }
        }

        private void printMessages(PrintWriter out, boolean isTopLevel) {
            if (isTopLevel) {
                out.println("<table width=100%>");
            }
            SummaryReport.this.printMessage(out, this.mList, isTopLevel, true);
            MessageLocationInfo s = this.sub;
            while (s != null) {
                s.printMessages(out, false);
                s = s.next;
            }
            if (isTopLevel) {
                out.println("</table>");
            }
        }

        private boolean inContext(int context) {
            return this.location != null && (this.location.astObjectKind == 6 && (context & 0x10) != 0 || this.location.astObjectKind == 8 && (context & 8) != 0 || this.location.astObjectKind == 1 && (context & 4) != 0 || this.location.astObjectKind == 7 && (context & 2) != 0 || this.location.astObjectKind == 0 && (context & 1) != 0);
        }

        private int toArray(MessageLocationInfo[] locs, int idxVal, int context) {
            int idx = idxVal;
            if (this.inContext(context)) {
                locs[idx++] = this;
            }
            MessageLocationInfo s = this.sub;
            while (s != null) {
                idx = s.toArray(locs, idx, context);
                s = s.next;
            }
            return idx;
        }

        private int countNodes(int context) {
            int n = 0;
            if (this.inContext(context)) {
                n = 1;
            }
            MessageLocationInfo s = this.sub;
            while (s != null) {
                n += s.countNodes(context);
                s = s.next;
            }
            return n;
        }

        static /* synthetic */ int[] access$102(MessageLocationInfo x0, int[] x1) {
            x0.counters = x1;
            return x1;
        }

        static /* synthetic */ int access$900(MessageLocationInfo x0) {
            return x0.counter;
        }
    }

    private class MessageLocation {
        private int astObjectKind;
        private String astObjectName;

        public MessageLocation(String objectName, int kind) {
            this.astObjectName = objectName;
            this.astObjectKind = kind;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MessageLocation) {
                MessageLocation loc = (MessageLocation)obj;
                return loc.astObjectKind == this.astObjectKind && loc.astObjectName == this.astObjectName;
            }
            return false;
        }

        public int hashCode() {
            return this.astObjectKind + this.astObjectName.hashCode();
        }
    }

    private class MessageClassInfo {
        private int counter;
        private IAnalyzerDescriptor analyzer;
        private MessageClassInfo next;
        private MessageReference mr;
        private int id;

        MessageClassInfo(MessageCategoryInfo info, IAnalyzerDescriptor analyzer) {
            this.analyzer = analyzer;
            this.next = info.cls;
            info.cls = this;
            this.id = SummaryReport.this.auditIdCounter;
            SummaryReport.this.auditIdCounter += 1;
        }

        void printStatistics(PrintWriter out, String detailsName, int level) {
            out.print("<LI>");
            out.println("<A HREF=\"" + detailsName + "#AU" + this.id + "\">" + this.analyzer.getName() + "</A>" + "\t---\t" + this.counter);
        }

        void printMessages(PrintWriter out) {
            out.println("<A NAME=AU" + this.id + ">" + SummaryReport.getLinkToAudit(this.analyzer, this.analyzer.getName()) + "</A>");
            out.println("<table width=100%>");
            SummaryReport.this.printMessage(out, this.mr, true, false);
            out.println("</table>");
            out.println("</UL>");
        }

        int listSeriousAudits(int nInfo, MessageClassInfo[] ci) {
            String s = this.mr.msg.getProblemSeverity();
            if (s != null && (s.equalsIgnoreCase("Error") || s.equalsIgnoreCase("Fatal"))) {
                ci[nInfo] = this;
                ++nInfo;
            }
            return nInfo;
        }
    }

    private class MessageCategoryInfo {
        private IAnalyzerCategory category;
        private int counter;
        private MessageCategoryInfo up;
        private MessageCategoryInfo next;
        private MessageCategoryInfo sub;
        private MessageClassInfo cls;

        MessageCategoryInfo find(IAnalyzerCategory c) {
            if (c == null) {
                return this;
            }
            MessageCategoryInfo upLink = this.find(c.getCategory());
            MessageCategoryInfo ii = upLink.sub;
            while (ii != null) {
                if (ii.category == c) {
                    return ii;
                }
                ii = ii.next;
            }
            return new MessageCategoryInfo(c, upLink);
        }

        MessageCategoryInfo(IAnalyzerCategory c, MessageCategoryInfo up) {
            this.category = c;
            this.up = up;
            this.next = up.sub;
            up.sub = this;
        }

        MessageCategoryInfo() {
        }

        void updateCounters() {
            MessageCategoryInfo ii = this.sub;
            while (ii != null) {
                ii.updateCounters();
                this.counter += ii.counter;
                ii = ii.next;
            }
            MessageClassInfo c = this.cls;
            while (c != null) {
                this.counter += c.counter;
                c = c.next;
            }
        }

        int listSeriousAudits(int nInfo, MessageClassInfo[] ci) {
            MessageCategoryInfo ii = this.sub;
            while (ii != null) {
                nInfo = ii.listSeriousAudits(nInfo, ci);
                ii = ii.next;
            }
            MessageClassInfo c = this.cls;
            while (c != null) {
                nInfo = c.listSeriousAudits(nInfo, ci);
                c = c.next;
            }
            return nInfo;
        }

        void printStatistics(PrintWriter out, String detailsName, PrintWriter details) {
            this.printStatistics(out, detailsName, 0);
            this.printMessages(details);
        }

        private void printStatistics(PrintWriter out, String detailsName, int level) {
            if (this.category != null) {
                out.print("<LI>");
                out.println(this.category.getName() + "\t---\t" + this.counter);
            }
            out.println("<UL>");
            MessageCategoryInfo ii = this.sub;
            while (ii != null) {
                ii.printStatistics(out, detailsName, level + 1);
                ii = ii.next;
            }
            MessageClassInfo c = this.cls;
            while (c != null) {
                c.printStatistics(out, detailsName, level + 1);
                c = c.next;
            }
            out.println("</UL>");
        }

        private void printMessages(PrintWriter out) {
            MessageCategoryInfo ii = this.sub;
            while (ii != null) {
                ii.printMessages(out);
                ii = ii.next;
            }
            MessageClassInfo c = this.cls;
            while (c != null) {
                c.printMessages(out);
                c = c.next;
            }
        }
    }

    private class MessageReference {
        private IReportMessage msg;
        private MessageReference ref;

        public MessageReference(IReportMessage msg, MessageReference ref) {
            this.ref = ref;
            this.msg = msg;
        }
    }

    private class StringNameTable {
        String[] t;

        private StringNameTable() {
        }

        void add(String s) {
            if (this.t == null) {
                this.t = new String[]{s};
            } else {
                int i = 0;
                while (i < this.t.length) {
                    if (this.t[i].equals(s)) {
                        return;
                    }
                    ++i;
                }
                String[] nt = new String[this.t.length + 1];
                int i2 = 0;
                while (i2 < this.t.length) {
                    nt[i2] = this.t[i2];
                    ++i2;
                }
                nt[this.t.length] = s;
                this.t = nt;
            }
        }

        int asIdx(String s) {
            int i = 0;
            while (i < this.t.length) {
                if (this.t[i].equals(s)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

