/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.report;

import java.io.PrintWriter;

public class PieChart {
    private static final int X_CENTER = 300;
    private static final int Y_CENTER = 300;
    private static final int RADIUS = 260;
    private static final int LINE_SIZE = 26;
    private String[] fillers = new String[]{"skyblue", "mediumvioletred", "lightyellow", "lightcyan", "purple", "salmon", "steelblue", "navy", "magenta", "yellow", "cyan", "maroon", "cadetblue", "blue"};

    public void printChart(PrintWriter out, int[] count, String[] name) {
        this.printHeader(out);
        this.printBody(out, count, name);
        this.printFooter(out);
    }

    private void printHeader(PrintWriter out) {
        out.println("<svg id=\"body\" width=\"16cm\" height=\"6cm\" viewBox=\"0 0 1200 600\">");
        out.println("<title></title>");
        out.println("<desc></desc>");
    }

    private void printFooter(PrintWriter out) {
        out.println("</svg>");
    }

    private void printBody(PrintWriter out, int[] count, String[] name) {
        int total = 0;
        int i = 0;
        while (i < count.length) {
            total += count[i];
            ++i;
        }
        if (total == 0) {
            return;
        }
        int color = 0;
        int sum = 0;
        int i2 = 0;
        while (i2 < count.length) {
            double angle1;
            double angle2 = (double)(sum += count[i2]) / (double)total * 2.0 * Math.PI - 1.5707963267948966;
            int largeArc = angle2 - (angle1 = (double)sum / (double)total * 2.0 * Math.PI - 1.5707963267948966) > Math.PI ? 1 : 0;
            double x1 = 260.0 * Math.cos(angle1) + 300.0;
            double y1 = 260.0 * Math.sin(angle1) + 300.0;
            double x2 = 260.0 * Math.cos(angle2) + 300.0;
            double y2 = 260.0 * Math.sin(angle2) + 300.0;
            out.println("<path d=\"M 300 300 L " + x1 + " " + y1 + " A " + 260 + " " + 260 + " " + 0 + " " + largeArc + " " + 1 + " " + x2 + " " + y2 + " Z\" " + "fill=\"" + this.fillers[color] + "\" stroke=\"black\" />");
            out.println("<rect x=\"620\" y=\"" + (100 + i2 * 26) + "\" width=\"" + 15.6 + "\" height = \"" + 15.6 + "\" fill=\"" + this.fillers[color] + "\" stroke=\"black\" />");
            out.println("<text x=\"646\" y=\"" + (102.0 + ((double)i2 + 0.5) * 26.0) + "\" font-family=\"Verdana\" font-size=\"" + 20.8 + "\">");
            out.println(name[i2]);
            out.println("</text>");
            if (++color >= this.fillers.length) {
                color = i2 < count.length - 2 ? 0 : 1;
            }
            ++i2;
        }
    }
}

