/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.Query;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.RowValueElement;
import com.sap.sql.tree.RowValueElementList;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;

public class TableValue
extends Query {
    private RowValue[] rowValues;

    public TableValue(RowValue[] aRowValueList) {
        this.rowValues = aRowValueList;
    }

    public TableValue(RowValueElementList aRowValueElementList) {
        this.rowValues = new RowValue[]{aRowValueElementList};
    }

    public TableValue(RowValueElement[] rowValueElements) {
        this.rowValues = new RowValue[]{new RowValueElementList(rowValueElements)};
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitTableValueBefore(this);
        if (this.rowValues != null) {
            int i = 0;
            while (i < this.rowValues.length) {
                if (this.rowValues[i] != null) {
                    this.rowValues[i].accept(visitor);
                }
                ++i;
            }
        }
        visitor.visitTableValue(this);
    }

    public RowValue[] getRowValues() {
        return this.rowValues;
    }

    public void setRowValues(RowValueElementList rvel) {
        this.rowValues = new RowValue[]{rvel};
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        strBuf.append("VALUES ");
        this.toSqlTxtAsList(this.rowValues[0], expert, strBuf);
        int i = 1;
        while (i < this.rowValues.length) {
            strBuf.append(", ");
            this.toSqlTxtAsList(this.rowValues[i], expert, strBuf);
            ++i;
        }
    }

    public void toSqlTxt(StringBuffer strBuf) {
        this.toSqlTxt(new SqlTextExpert(), strBuf);
    }

    private void toSqlTxtAsList(RowValue value, SqlTextExpert expert, StringBuffer strBuf) {
        if (value instanceof RowValueElement) {
            strBuf.append("( ");
        }
        value.toSqlTxt(expert, strBuf);
        if (value instanceof RowValueElement) {
            strBuf.append(") ");
        }
    }
}

