/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;
import com.sap.sql.tree.ValueExpression;

public class SetFunction
extends ValueExpression {
    public static final int AVG = 1;
    public static final int MIN = 2;
    public static final int MAX = 3;
    public static final int SUM = 4;
    public static final int COUNT = 5;
    private int setFunctionType;
    private ValueExpression argument;
    private boolean distinct;

    public SetFunction(int aSetFunctionType, ValueExpression anArgument) {
        this.setFunctionType = aSetFunctionType;
        this.argument = anArgument;
    }

    public SetFunction(int aSetFunctionType, boolean isDistinct, ValueExpression anArgument) {
        this.setFunctionType = aSetFunctionType;
        this.argument = anArgument;
        this.distinct = isDistinct;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitSetFunctionBefore(this);
        if (this.argument != null) {
            this.argument.accept(visitor);
        }
        visitor.visitSetFunction(this);
    }

    public int getSetFunctionType() {
        return this.setFunctionType;
    }

    public ValueExpression getArgument() {
        return this.argument;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        switch (this.setFunctionType) {
            case 1: {
                strBuf.append("AVG");
                break;
            }
            case 2: {
                strBuf.append("MIN");
                break;
            }
            case 3: {
                strBuf.append("MAX");
                break;
            }
            case 4: {
                strBuf.append("SUM");
                break;
            }
            case 5: {
                strBuf.append("COUNT");
                break;
            }
        }
        strBuf.append("(");
        if (this.distinct) {
            strBuf.append("DISTINCT ");
        }
        this.argument.toSqlTxt(expert, strBuf);
        strBuf.append(")");
    }
}

