/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.ColumnReference;
import com.sap.sql.tree.GeneralSelectStatement;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.QuerySpecification;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SelectSublist;
import com.sap.sql.tree.SqlTextExpert;
import com.sap.sql.tree.TableReference;

public class SelectForUpdateStatement
extends GeneralSelectStatement {
    private ColumnReference[] updateFieldList;

    public SelectForUpdateStatement(SelectSublist[] aSelectList, TableReference aFromClause, SearchCondition aWhereClause, ColumnReference[] aUpdateFieldList) {
        super(new QuerySpecification(aSelectList, new Query[]{aFromClause}, aWhereClause));
        this.updateFieldList = aUpdateFieldList;
    }

    public void accept(SQLVisitor visitor) {
        visitor.setStatemntType(this.getStatementType());
        visitor.visitSelectForUpdateBefore(this);
        this.query.accept(visitor);
        if (this.updateFieldList != null) {
            int i = 0;
            while (i < this.updateFieldList.length) {
                if (this.updateFieldList[i] != null) {
                    this.updateFieldList[i].accept(visitor);
                }
                ++i;
            }
        }
        visitor.visitSelectForUpdate(this);
    }

    public SelectSublist[] getSelectList() {
        return ((QuerySpecification)this.query).getSelectList();
    }

    public TableReference getFromClause() {
        return (TableReference)((QuerySpecification)this.query).getFromClause()[0];
    }

    public SearchCondition getWhereClause() {
        return ((QuerySpecification)this.query).getWhereClause();
    }

    public ColumnReference[] getUpdateFieldList() {
        return this.updateFieldList;
    }

    void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        this.query.toSqlTxt(expert, strBuf);
        strBuf.append(" FOR UPDATE ");
        if (this.updateFieldList != null) {
            strBuf.append(" OF ");
            this.updateFieldList[0].toSqlTxt(expert, strBuf);
            int i = 1;
            while (i < this.updateFieldList.length) {
                strBuf.append(", ");
                this.updateFieldList[i].toSqlTxt(expert, strBuf);
                ++i;
            }
        }
    }

    public int getStatementType() {
        return 32;
    }
}

