/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.trace.TraceContext;
import com.sap.sql.tree.MssSqlTextExpert;
import com.sap.sql.tree.OracleSqlTextExpert;
import com.sap.sql.tree.ResultDescriptor;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;
import java.io.Serializable;

public abstract class SQLStatement
implements Serializable {
    public static final int UNKNOWN = 1;
    public static final int SELECT = 2;
    public static final int INSERT = 4;
    public static final int UPDATE = 8;
    public static final int DELETE = 16;
    public static final int SELECT_FOR_UPDATE = 32;
    public static final int COMMIT = 64;
    public static final int ROLLBACK = 128;
    public static final int CREATE_VIEW = 256;
    String sqlString = null;
    private ResultDescriptor[] hostVariablesList = null;
    private Object bufferStatementInfo;
    private TraceContext traceContext;

    public abstract void accept(SQLVisitor var1);

    public ResultDescriptor[] getHostVariablesList() {
        return this.hostVariablesList;
    }

    public void setHostVariablesList(ResultDescriptor[] hostVariablesList) {
        this.hostVariablesList = hostVariablesList;
    }

    public Object getBufferStatementInfo() {
        return this.bufferStatementInfo;
    }

    public void setBufferStatementInfo(Object bufferStatementInfo) {
        this.bufferStatementInfo = bufferStatementInfo;
    }

    public boolean getHintBypassingBuffer() {
        return false;
    }

    public void setBufferable(boolean bufferable) {
    }

    public void setTraceContext(TraceContext traceContext) {
        this.traceContext = traceContext;
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    public abstract int getStatementType();

    public String getStatementTypeName() {
        int type = this.getStatementType();
        switch (type) {
            case 2: {
                return "SELECT";
            }
            case 4: {
                return "INSERT";
            }
            case 8: {
                return "UPDATE";
            }
            case 16: {
                return "DELETE";
            }
            case 32: {
                return "SELECT FOR UPDATE";
            }
            case 64: {
                return "COMMIT";
            }
            case 128: {
                return "ROLLBAKC";
            }
            case 256: {
                return "CREATE VIEW";
            }
        }
        return "UNKNOWN STATEMENT TYPE: " + type;
    }

    abstract void toSqlTxt(SqlTextExpert var1, StringBuffer var2);

    public final void toSqlTxt(StringBuffer strBuf) {
        this.toSqlTxt(new SqlTextExpert(), strBuf);
    }

    public final String toSqlString() {
        return this.toSqlString(-1);
    }

    public final String toSqlString(int databaseVendor) {
        SqlTextExpert expert;
        switch (databaseVendor) {
            case 5: {
                expert = new OracleSqlTextExpert();
                break;
            }
            case 4: {
                expert = new MssSqlTextExpert();
                break;
            }
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                expert = new SqlTextExpert();
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for database vendor: " + databaseVendor);
            }
        }
        StringBuffer buffer = new StringBuffer();
        this.toSqlTxt(expert, buffer);
        return buffer.toString();
    }
}

