/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.ComparisonOperator;
import com.sap.sql.tree.HostVariableValues;
import com.sap.sql.tree.Query;
import com.sap.sql.tree.RowValue;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SqlTextExpert;
import java.sql.ResultSet;
import java.sql.SQLException;

public class QuantifiedComparisonPredicate
extends SearchCondition {
    public static final int ALL = 1;
    public static final int ANY = 2;
    public static final int SOME = 3;
    private RowValue value;
    private int comparisonOperator;
    private int quantifier;
    private Query subquery;

    public QuantifiedComparisonPredicate(RowValue aValue, int aComparisonOperator, int aQuantifier, Query aSubquery) {
        this.value = aValue;
        this.comparisonOperator = aComparisonOperator;
        this.quantifier = aQuantifier;
        this.subquery = aSubquery;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitQuantifiedComparisonPredicateBefore(this);
        if (this.value != null) {
            this.value.accept(visitor);
        }
        if (this.subquery != null) {
            this.subquery.accept(visitor);
        }
        visitor.visitQuantifiedComparisonPredicate(this);
    }

    public RowValue getValue() {
        return this.value;
    }

    public int getOperator() {
        return this.comparisonOperator;
    }

    public int getQuantifier() {
        return this.quantifier;
    }

    public Query getSubquery() {
        return this.subquery;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        this.value.toSqlTxt(expert, strBuf);
        strBuf.append(' ');
        strBuf.append(ComparisonOperator.getText(this.comparisonOperator));
        strBuf.append(' ');
        switch (this.quantifier) {
            case 1: {
                strBuf.append(" ALL ");
                break;
            }
            case 2: {
                strBuf.append(" ANY ");
                break;
            }
            case 3: {
                strBuf.append(" SOME ");
            }
        }
        expert.toSubquery(this.subquery, strBuf);
    }

    public boolean evaluate(HostVariableValues values, ResultSet rs) throws SQLException {
        throw new SQLException("tmp");
    }

    public boolean supportsEvaluation() {
        return false;
    }
}

