/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.Literal;
import com.sap.sql.tree.ResultDescriptor;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SqlTextExpert;
import java.math.BigInteger;

public class IntegerLiteral
extends Literal {
    private final Number value;
    private final ResultDescriptor result;

    public IntegerLiteral(String literal) {
        int resultPrecision;
        int resultType;
        BigInteger bigValue = new BigInteger(literal);
        int bitLength = bigValue.bitLength();
        if (++bitLength <= 16) {
            resultType = 5;
            resultPrecision = 5;
            this.value = new Short(literal);
        } else if (bitLength <= 32) {
            resultType = 4;
            resultPrecision = 10;
            this.value = new Integer(literal);
        } else if (bitLength <= 64) {
            resultType = -5;
            resultPrecision = 19;
            this.value = new Long(literal);
        } else {
            resultType = 3;
            resultPrecision = 3 * bitLength / 10;
            this.value = bigValue;
        }
        this.result = new ResultDescriptor(resultType, (long)resultPrecision, 0, true);
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitIntegerLiteralBefore(this);
        visitor.visitIntegerLiteral(this);
    }

    public Number getValue() {
        return this.value;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        strBuf.append(this.toString());
    }

    public ResultDescriptor getResultDescriptor() {
        return this.result;
    }

    public String toString() {
        return this.value.toString();
    }
}

