/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.HostVariableValues;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SqlTextExpert;
import com.sap.sql.tree.ValueExpression;
import java.sql.ResultSet;
import java.sql.SQLException;

public class InListPredicate
extends SearchCondition {
    private ValueExpression value;
    private ValueExpression[] valueList;
    private boolean notIn = false;

    public InListPredicate(ValueExpression aValue, ValueExpression[] aValueList) {
        this.value = aValue;
        this.valueList = aValueList;
    }

    public InListPredicate(ValueExpression aValue, ValueExpression[] aValueList, boolean isNotIn) {
        this.value = aValue;
        this.valueList = aValueList;
        this.notIn = isNotIn;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitInListPredicateBefore(this);
        if (this.value != null) {
            this.value.accept(visitor);
        }
        if (this.valueList != null) {
            int i = 0;
            while (i < this.valueList.length) {
                if (this.valueList[i] != null) {
                    this.valueList[i].accept(visitor);
                }
                ++i;
            }
        }
        visitor.visitInListPredicate(this);
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public ValueExpression[] getValueList() {
        return this.valueList;
    }

    public boolean isNotIn() {
        return this.notIn;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        this.value.toSqlTxt(expert, strBuf);
        if (this.notIn) {
            strBuf.append(" NOT");
        }
        strBuf.append(" IN ");
        if (this.valueList != null && this.valueList.length > 0) {
            strBuf.append("(");
            this.valueList[0].toSqlTxt(expert, strBuf);
            int expr_i = 1;
            while (expr_i < this.valueList.length) {
                strBuf.append(",");
                this.valueList[expr_i].toSqlTxt(expert, strBuf);
                ++expr_i;
            }
            strBuf.append(")");
        }
    }

    public boolean evaluate(HostVariableValues values, ResultSet rs) throws SQLException {
        throw new SQLException("tmp");
    }

    public boolean supportsEvaluation() {
        return false;
    }
}

