/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.tree;

import com.sap.sql.tree.BooleanAnd;
import com.sap.sql.tree.BooleanOr;
import com.sap.sql.tree.HostVariableValues;
import com.sap.sql.tree.SQLVisitor;
import com.sap.sql.tree.SearchCondition;
import com.sap.sql.tree.SqlTextExpert;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BooleanNot
extends SearchCondition {
    private SearchCondition operand;

    public BooleanNot(SearchCondition aCondition) {
        this.operand = aCondition;
    }

    public void accept(SQLVisitor visitor) {
        visitor.visitBooleanNotBefore(this);
        if (this.operand != null) {
            this.operand.accept(visitor);
        }
        visitor.visitBooleanNot(this);
    }

    public SearchCondition getOperand() {
        return this.operand;
    }

    public void toSqlTxt(SqlTextExpert expert, StringBuffer strBuf) {
        boolean use_braces = this.operand instanceof BooleanAnd && ((BooleanAnd)this.operand).getOperands().length > 1 || this.operand instanceof BooleanOr && ((BooleanOr)this.operand).getOperands().length > 1 || this.operand instanceof BooleanNot;
        strBuf.append("NOT ");
        if (use_braces) {
            strBuf.append("(");
        }
        this.operand.toSqlTxt(expert, strBuf);
        if (use_braces) {
            strBuf.append(")");
        }
    }

    public boolean evaluate(HostVariableValues hv, ResultSet rs) throws SQLException {
        return !this.operand.evaluate(hv, rs);
    }
}

