/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.catalog;

import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Table;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Hashtable;

public class CachedCatalogReader
implements CatalogReader {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$catalog$CachedCatalogReader == null ? (class$com$sap$sql$catalog$CachedCatalogReader = CachedCatalogReader.class$("com.sap.sql.catalog.CachedCatalogReader")) : class$com$sap$sql$catalog$CachedCatalogReader));
    private ArrayList crs = null;
    private Hashtable tableCache = new Hashtable();
    static /* synthetic */ Class class$com$sap$sql$catalog$CachedCatalogReader;

    public CachedCatalogReader(CatalogReader cr) {
        this.crs = new ArrayList();
        this.crs.add(cr);
        TRACE.debugT("CachedCatalogReader", "cached catalog reader created with one underlying catalog reader. Hashcode: " + cr.hashCode());
    }

    public CachedCatalogReader(CatalogReader[] crs) {
        this.crs = new ArrayList();
        int i = 0;
        while (i < crs.length) {
            this.crs.add(crs[i]);
            ++i;
        }
        TRACE.debugT("CachedCatalogReader", "cached catalog reader created with " + crs.length + "underlying catalog readers.");
    }

    public void addReader(CatalogReader cr) {
        this.crs.add(cr);
        TRACE.debugT("CachedCatalogReader", "catalog reader added. Hashcode: " + cr.hashCode());
    }

    public void addReaderAll(CatalogReader[] crs) {
        int i = 0;
        while (i < crs.length) {
            this.addReader(crs[i]);
            ++i;
        }
    }

    public void removeReader(CatalogReader cr) {
        this.resetCache();
        ((AbstractCollection)this.crs).remove(cr);
        TRACE.debugT("CachedCatalogReader", "catalog reader removed. Hashcode: " + cr.hashCode());
    }

    public void removeReaderAll(CatalogReader[] crs) {
        int i = 0;
        while (i < crs.length) {
            this.removeReader(crs[i]);
            ++i;
        }
    }

    public void invalidateTable(String tableName) {
        this.invalidateTable(null, tableName);
    }

    public void invalidateTable(String schemaName, String tableName) {
        String qualifiedName = schemaName != null ? schemaName + "." + tableName : tableName;
        this.tableCache.remove(qualifiedName);
        TRACE.debugT("invalidateTable", qualifiedName + " removed from the cache.");
    }

    public void resetCache() {
        this.tableCache.clear();
        TRACE.debugT("resetCache", "Cache cleared");
    }

    public Table getTable(String tableName) throws SQLException {
        return this.getTable(null, tableName);
    }

    public Table getTable(String schemaName, String tableName) throws SQLException {
        String qualifiedName = schemaName != null ? schemaName + "." + tableName : tableName;
        Object obj = this.tableCache.get(qualifiedName);
        if (null == obj) {
            Table table = null;
            if (schemaName != null) {
                int i = 0;
                while (i < this.crs.size()) {
                    table = ((CatalogReader)this.crs.get(i)).getTable(schemaName, tableName);
                    if (table == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                int i = 0;
                while (i < this.crs.size()) {
                    table = ((CatalogReader)this.crs.get(i)).getTable(tableName);
                    if (table == null) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            if (table != null) {
                TRACE.debugT("getTable", "put " + qualifiedName + " into the cache.");
                this.tableCache.put(qualifiedName, table);
            }
            return table;
        }
        return (Table)obj;
    }

    public boolean existsTable(String tableName) throws SQLException {
        return this.existsTable(null, tableName);
    }

    public boolean existsTable(String schemaName, String tableName) throws SQLException {
        String qualifiedName;
        String string = qualifiedName = schemaName != null ? schemaName + "." + tableName : tableName;
        if (this.tableCache.get(qualifiedName) != null) {
            return true;
        }
        int i = 0;
        while (i < this.crs.size()) {
            if (((CatalogReader)this.crs.get(i)).existsTable(schemaName, tableName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isLogicalCatalogReader() {
        int i = 0;
        while (i < this.crs.size()) {
            if (!((CatalogReader)this.crs.get(i)).isLogicalCatalogReader()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void close() {
        this.tableCache.clear();
        this.tableCache = null;
        this.crs = null;
        TRACE.debugT("CachedCatalogReader", "cached catalog reader closed.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

