/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.prop.impl;

import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.BaseRuntimeException;
import com.sap.aii.util.prop.api.PropertyNode;
import com.sap.aii.util.prop.impl.BasicPropertySource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLFilePropertySource
extends BasicPropertySource {
    private static final Logger log = Logger.getLogger((class$com$sap$aii$util$prop$impl$XMLFilePropertySource == null ? (class$com$sap$aii$util$prop$impl$XMLFilePropertySource = XMLFilePropertySource.class$("com.sap.aii.util.prop.impl.XMLFilePropertySource")) : class$com$sap$aii$util$prop$impl$XMLFilePropertySource).getName());
    public static final String PARAMETER_FILENAME = "fileName";
    public static final String DEFAULT_FILENAME = "properties.xml";
    private String fileName;
    private Properties fileProp;
    private static final String XML_START = "<?xml";
    private static final int MODE_PROP = 0;
    private static final int MODE_XML = 1;
    static /* synthetic */ Class class$com$sap$aii$util$prop$impl$XMLFilePropertySource;

    public XMLFilePropertySource() throws IOException {
        this(DEFAULT_FILENAME);
    }

    public XMLFilePropertySource(String fileName) throws IOException {
        this.fileName = fileName;
        this.fileProp = new Properties();
        this.readFile();
        this.setPropertySet(new BasicPropertySource.PropertiesAdapter(this.fileProp));
    }

    public XMLFilePropertySource(Properties parameters) throws IOException {
        this(parameters.getProperty(PARAMETER_FILENAME));
    }

    public String getName() {
        return "XMLPropertySource(\"" + this.fileName + "\")";
    }

    protected String getLocalDir() {
        return new File(this.fileName).getParent();
    }

    private int testFileType() throws IOException {
        int mode = 0;
        char[] buffer = new char[5];
        FileReader fis = new FileReader(this.fileName);
        int len = fis.read(buffer);
        if (XML_START.equals(new String(buffer, 0, len))) {
            mode = 1;
        }
        fis.close();
        return mode;
    }

    public void sync() {
        try {
            this.readFile();
        }
        catch (IOException e) {
            throw new BaseRuntimeException(e);
        }
        this.syncFallbackSource();
    }

    public void flush() {
        try {
            this.writeFile();
        }
        catch (IOException e) {
            throw new BaseRuntimeException(e);
        }
    }

    private void readFile() throws IOException {
        ((Hashtable)this.fileProp).clear();
        FileInputStream fis = new FileInputStream(this.fileName);
        XMLFilePropertySource.readXML(fis, "", this.getRoot());
        fis.close();
    }

    protected void writeFile() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.fileName);
        XMLFilePropertySource.writeXML(this.getRoot(), fos);
        fos.close();
    }

    private static void writeXML(PropertyNode node, OutputStream out) throws IOException {
        try {
            TransformerFactory tfac = TransformerFactory.newInstance();
            Transformer trans = tfac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fac.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("properties");
            doc.appendChild(root);
            root.appendChild(XMLFilePropertySource.exportXML(node, doc));
            trans.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (Exception e) {
            log.error("unexpected exception", e);
        }
    }

    private static Element exportXML(PropertyNode node, Document doc) {
        try {
            Element element = doc.createElement(node.isRoot() ? "root" : "node");
            element.setAttribute("name", node.getName());
            String[] names = node.getPropertyNames();
            int i = 0;
            while (i < names.length) {
                Element entry = doc.createElement("property");
                entry.setAttribute("name", names[i]);
                entry.setAttribute("value", node.getProperty(names[i]));
                element.appendChild(entry);
                ++i;
            }
            names = node.getNodeNames();
            int i2 = 0;
            while (i2 < names.length) {
                element.appendChild(XMLFilePropertySource.exportXML(node.getNode(names[i2]), doc));
                ++i2;
            }
            return element;
        }
        catch (Exception e) {
            log.error("unexpected exception", e);
            return null;
        }
    }

    private static void importXML(Element element, PropertyNode targetNode) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                Element elem = (Element)node;
                String name = elem.getLocalName();
                if (name.equals("node")) {
                    XMLFilePropertySource.importXML(elem, targetNode.getNode(elem.getAttribute("name")));
                } else if (name.equals("property")) {
                    targetNode.setProperty(elem.getAttribute("name"), elem.getAttribute("value"));
                }
            }
            node = node.getNextSibling();
        }
    }

    private static void readXML(InputStream in, String rootName, PropertyNode targetNode) throws IOException {
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fac.newDocumentBuilder();
            Document doc = builder.parse(in);
            Element docRoot = (Element)doc.getFirstChild();
            Node node = docRoot.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1 && node.getLocalName().equals("root")) {
                    XMLFilePropertySource.importXML((Element)node, targetNode);
                }
                node = node.getNextSibling();
            }
        }
        catch (Exception e) {
            log.error("unexpected exception", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

