/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.prop.impl;

import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.BaseRuntimeException;
import com.sap.aii.util.misc.api.IOUtil;
import com.sap.aii.util.prop.impl.BasicPropertySource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class FilePropertySource
extends BasicPropertySource {
    private static final Logger log = Logger.getLogger((class$com$sap$aii$util$prop$impl$FilePropertySource == null ? (class$com$sap$aii$util$prop$impl$FilePropertySource = FilePropertySource.class$("com.sap.aii.util.prop.impl.FilePropertySource")) : class$com$sap$aii$util$prop$impl$FilePropertySource).getName());
    public static final String PARAMETER_FILENAME = "fileName";
    public static final String DEFAULT_FILENAME = "aii.properties";
    private String fileName;
    private Properties fileProp;
    static /* synthetic */ Class class$com$sap$aii$util$prop$impl$FilePropertySource;

    public FilePropertySource() throws IOException {
        this(DEFAULT_FILENAME);
    }

    public FilePropertySource(String fileName) throws IOException {
        this.fileName = IOUtil.getCanonicalFileName(fileName);
        this.fileProp = new Properties();
        this.readFile();
        this.setPropertySet(new BasicPropertySource.PropertiesAdapter(this.fileProp));
    }

    public FilePropertySource(Properties parameters) throws IOException {
        this(BasicPropertySource.resolveFile(parameters.getProperty("localDir"), parameters.getProperty(PARAMETER_FILENAME)));
    }

    public String getName() {
        return "FilePropertySource(\"" + this.fileName + "\")";
    }

    protected String getLocalDir() {
        return new File(this.fileName).getParent();
    }

    public void sync() {
        try {
            this.readFile();
        }
        catch (IOException e) {
            throw new BaseRuntimeException(e);
        }
        this.syncFallbackSource();
    }

    public void flush() {
        try {
            this.writeFile();
        }
        catch (IOException e) {
            throw new BaseRuntimeException(e);
        }
    }

    protected void readFile() throws IOException {
        ((Hashtable)this.fileProp).clear();
        FileInputStream fis = new FileInputStream(this.fileName);
        this.fileProp.load(fis);
        fis.close();
    }

    protected void writeFile() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.fileName);
        this.fileProp.store(fos, "FilePropertySource");
        fos.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

