/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.prop.api;

import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.prop.api.PropertyNode;
import com.sap.aii.util.prop.api.PropertySet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class PropertyTools {
    private static final Logger log = Logger.getLogger((class$com$sap$aii$util$prop$api$PropertyTools == null ? (class$com$sap$aii$util$prop$api$PropertyTools = PropertyTools.class$("com.sap.aii.util.prop.api.PropertyTools")) : class$com$sap$aii$util$prop$api$PropertyTools).getName());
    static /* synthetic */ Class class$com$sap$aii$util$prop$api$PropertyTools;

    public static Properties exportProperties(PropertySet set, String oldPrefix, String newPrefix) {
        Properties result = new Properties();
        int start_pos = oldPrefix.length();
        String[] names = set.getPropertyNames();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (name.startsWith(oldPrefix)) {
                result.setProperty(newPrefix + name.substring(start_pos), set.getProperty(name));
            }
            ++i;
        }
        return result;
    }

    public static Properties exportProperties(PropertyNode node, String baseName, boolean includeSubNodes) {
        if (baseName == null) {
            baseName = "";
        }
        if (!baseName.equals("")) {
            baseName = baseName + '.';
        }
        Properties prop = new Properties();
        PropertyTools.addNode(node, prop, baseName, includeSubNodes);
        return prop;
    }

    private static void addNode(PropertyNode node, Properties prop, String baseName, boolean includeSubNodes) {
        String[] names = node.getPropertyNames();
        int i = 0;
        while (i < names.length) {
            prop.setProperty(baseName + names[i], node.getProperty(names[i]));
            ++i;
        }
        if (includeSubNodes) {
            names = node.getNodeNames();
            int i2 = 0;
            while (i2 < names.length) {
                PropertyTools.addNode(node.getNode(names[i2]), prop, baseName + names[i2] + ".", includeSubNodes);
                ++i2;
            }
        }
    }

    public static void importProperties(PropertyNode node, Properties prop, String baseName) {
        if (baseName == null) {
            baseName = "";
        }
        if (!baseName.equals("")) {
            baseName = baseName + '.';
        }
        int pos = baseName.length();
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(baseName)) continue;
            node.setProperty(name.substring(pos), prop.getProperty(name));
        }
    }

    public static Set extractPropertyNames(PropertySet set, String nodeName) {
        String[] props = set.getPropertyNames();
        HashSet<String> result = new HashSet<String>();
        int pos = nodeName.length();
        int i = 0;
        while (i < props.length) {
            int pos2;
            String name = props[i];
            if (name.startsWith(nodeName) && (pos2 = name.indexOf(46, pos)) < 0) {
                result.add(name.substring(pos));
            }
            ++i;
        }
        return result;
    }

    public static Set extractNodeNames(PropertySet set, String nodeName) {
        String[] props = set.getPropertyNames();
        HashSet<String> result = new HashSet<String>();
        int pos = nodeName.length();
        int i = 0;
        while (i < props.length) {
            int pos2;
            String name = props[i];
            if (name.startsWith(nodeName) && (pos2 = name.indexOf(46, pos)) >= 0) {
                result.add(name.substring(pos, pos2));
            }
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

