/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.prop.api;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.Util;
import com.sap.aii.util.prop.api.PropertySource;
import com.sap.aii.util.prop.impl.BasicPropertySource;
import com.sap.aii.util.prop.impl.FilePropertySource;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class PropertySourceFactory {
    private static final Logger log = Logger.getLogger((class$com$sap$aii$util$prop$api$PropertySourceFactory == null ? (class$com$sap$aii$util$prop$api$PropertySourceFactory = PropertySourceFactory.class$("com.sap.aii.util.prop.api.PropertySourceFactory")) : class$com$sap$aii$util$prop$api$PropertySourceFactory).getName());
    private static PropertySource defaultSource = null;
    static /* synthetic */ Class class$com$sap$aii$util$prop$api$PropertySourceFactory;

    private PropertySourceFactory() {
    }

    public static synchronized PropertySource getPropertySource() {
        if (defaultSource == null) {
            Throwable t = new Throwable("dummy Throwable for stack trace");
            log.log(Level.WARNING, "PropertySource not set!", t);
            File defaultFile = new File("aii.properties");
            String path = defaultFile.getAbsolutePath();
            try {
                defaultSource = new FilePropertySource();
                log.warning("using default properties file \"" + path + "\"");
            }
            catch (IOException io) {
                log.error("reading default properties file \"" + path + "\" failed - " + Util.getClassName(io) + ": " + io.getMessage());
            }
            if (defaultSource == null) {
                log.fatal("no PropertySource available!", t);
                defaultSource = new BasicPropertySource(new Properties(), "");
            }
        }
        return defaultSource;
    }

    public static synchronized void setPropertySource(PropertySource source) {
        if (defaultSource != null) {
            log.warning("PropertySource already set! (old=" + defaultSource.getName() + ", new=" + source.getName() + ")");
        }
        defaultSource = source;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

