/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.misc.api.Cache;
import com.sap.aii.util.misc.api.InvalidArgumentException;
import com.sap.aii.util.misc.api.ResourceException;

public final class PeriodicCache
extends Cache {
    private long interval = 0L;
    private long nextRefresh = 0L;

    public PeriodicCache(Cache cache, long interval) {
        super(cache);
        this.interval = interval;
    }

    public Object get(Object x) throws ResourceException, InvalidArgumentException {
        if (this.interval >= 0L && System.currentTimeMillis() > this.nextRefresh) {
            this.refresh();
        }
        return super.get(x);
    }

    public void refresh() {
        if (this.interval > 0L) {
            this.nextRefresh = System.currentTimeMillis() + this.interval;
        }
        super.refresh();
    }
}

