/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.StringUtil;
import java.io.File;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.StringTokenizer;

public class Finder {
    public static final String JARSIGNER = "jarsigner";
    public static final String JARSIGNER_EXE = "jarsigner.exe";
    public static final String JARSIGNER_UNIX = "jarsigner";
    public static final String JAVAC = "javac*";
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static final String JAVA_HOME = System.getProperty("java.home");
    private static final String LIB_DIR = "bin";
    private static final Logger log = Logger.getLogger((class$com$sap$aii$util$misc$api$Finder == null ? (class$com$sap$aii$util$misc$api$Finder = Finder.class$("com.sap.aii.util.misc.api.Finder")) : class$com$sap$aii$util$misc$api$Finder).getName());
    private static Finder _Finder = null;
    private HashMap resourceMap = null;
    static /* synthetic */ Class class$com$sap$aii$util$misc$api$Finder;

    private Finder() {
        log.debug("JAVA_HOME=" + JAVA_HOME);
        log.debug("USER_DIR=" + USER_DIR);
        this.resourceMap = new HashMap();
        boolean test = this.addStandardResource(this.resourceMap, "jarsigner", "jarsigner");
        if (!test) {
            test = this.addStandardResource(this.resourceMap, JARSIGNER_EXE, "jarsigner");
        }
        if (!test) {
            log.error("No jarsigner found!");
        }
        this.addStandardResource(this.resourceMap, JAVAC, JAVAC);
    }

    private boolean addStandardResource(HashMap map, String name, String alias) {
        int i;
        File file = Finder.findResourceInPath(JAVA_HOME + FILE_SEP + LIB_DIR, name);
        if (file == null && (i = JAVA_HOME.lastIndexOf(FILE_SEP)) > 0) {
            String javaHomeParent = JAVA_HOME.substring(0, i);
            file = Finder.findResourceInPath(javaHomeParent + FILE_SEP + LIB_DIR, name);
        }
        if (file != null) {
            map.put(alias, file.getPath());
        }
        return file != null;
    }

    public static synchronized Finder getInstance() throws MissingResourceException {
        if (_Finder == null) {
            _Finder = new Finder();
        }
        return _Finder;
    }

    public String get(String resource) {
        return (String)this.resourceMap.get(resource);
    }

    public static File findResourceInPath(String userDir, String searchPath, String resource) {
        File inFile = null;
        StringTokenizer pathTokens = new StringTokenizer(searchPath, ";");
        while (pathTokens.hasMoreElements()) {
            String actPath = (String)pathTokens.nextElement();
            inFile = Finder.findResourceInDir(userDir + FILE_SEP + actPath, resource);
            if (inFile != null) break;
        }
        return inFile;
    }

    public static File findResourceInPath(String searchPath, String resource) {
        return Finder.findResourceInPath("", searchPath, resource);
    }

    private static boolean endsWith(String path, String e) {
        boolean result = false;
        if (path.length() >= e.length()) {
            result = path.substring(path.length() - e.length()).equals(e);
        }
        return result;
    }

    private static String getNormalizedPath(String path) {
        String result = path;
        if (Finder.endsWith(result, "*")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static File findResourceInDir(String dir, String resource) {
        File result = null;
        String shortDir = Finder.getNormalizedPath(dir);
        if (shortDir != null) {
            int pos;
            File tmpFile = new File(shortDir);
            File[] fileList = tmpFile.listFiles();
            if (fileList != null && (pos = Finder.searchFileList(fileList, resource)) >= 0) {
                result = fileList[pos];
                log.debug("... checking " + result.toString());
                if (result != null && !result.exists()) {
                    result = null;
                }
            }
            if (result == null && Finder.endsWith(dir, "*") && fileList != null) {
                int i = 0;
                while (i < fileList.length) {
                    if (fileList[i].isDirectory()) {
                        log.debug("entering directory " + shortDir + FILE_SEP + fileList[i] + FILE_SEP + "*");
                        result = Finder.findResourceInDir(shortDir + FILE_SEP + fileList[i].getName() + FILE_SEP + "*", resource);
                        if (result != null) break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private static int searchFileList(File[] fileList, String pattern) {
        int i = 0;
        while (i < fileList.length) {
            String name;
            if (!fileList[i].isDirectory() && StringUtil.equalsPattern(name = fileList[i].getName().toUpperCase(), pattern.toUpperCase())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getBaseName(String s) {
        String result = "";
        int slashPos = s.lastIndexOf("/");
        if (slashPos < 0) {
            slashPos = s.lastIndexOf("\\");
        }
        if (slashPos >= 0 && slashPos < s.length()) {
            result = s.substring(slashPos + 1);
        }
        return result;
    }

    public static void main(String[] args) {
        new Finder();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

