/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.misc.api.Message;
import com.sap.aii.util.misc.api.MessageIcon;
import com.sap.aii.util.misc.api.MessagePara;

public class CheckMessage
extends MessagePara {
    private Level severity = Level.INFO;
    private String errorLocation;
    public static final Level HEADLINE_LEVEL = Level.FINEST;

    public CheckMessage() {
    }

    public CheckMessage(Message message) {
        this(message, Level.INFO);
    }

    public CheckMessage(Message message, Level severity) {
        super(message);
        this.setSeverity(severity);
    }

    public void addMessage(Message msg) {
        this.add(msg);
    }

    public boolean isHeadline() {
        return this.getSeverity().equals(HEADLINE_LEVEL);
    }

    public void setSeverity(Level severity) {
        this.severity = severity;
        MessageIcon icon = CheckMessage.severityToIcon(severity);
        if (icon == null) {
            if (this.size() > 0 && this.get(0) instanceof MessageIcon) {
                this.remove(0);
            }
        } else if (this.size() > 0 && this.get(0) instanceof MessageIcon) {
            this.set(0, icon);
        } else {
            this.insert(0, icon);
        }
    }

    public Level getSeverity() {
        return this.severity;
    }

    public void setErrorLocation(String errorLocation) {
        this.errorLocation = errorLocation;
    }

    public String getErrorLocation() {
        return this.errorLocation;
    }

    public static MessageIcon severityToIcon(Level severity) {
        if (severity == null || severity.getPriority() < Level.INFO.getPriority()) {
            return null;
        }
        if (severity.getPriority() == Level.INFO.getPriority()) {
            return MessageIcon.INFO;
        }
        if (severity.getPriority() <= Level.WARNING.getPriority()) {
            return MessageIcon.WARNING;
        }
        if (severity.getPriority() <= Level.ERROR.getPriority()) {
            return MessageIcon.ERROR;
        }
        return MessageIcon.FATAL;
    }
}

