/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.misc.api.BaseException;
import com.sap.aii.util.misc.api.IBaseException;
import com.sap.aii.util.misc.api.Message;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;

public class BaseRuntimeException
extends RuntimeException
implements IBaseException {
    private static final long serialVersionUID = 42L;
    private static final String AUTOLOG_TAG = "creating instance of ";
    private static boolean INITIALIZED_AUTOLOG = false;
    private Throwable rootCause;
    private BabelMessage message;
    private Message assistance;
    private Level severity = Level.FATAL;
    private boolean wrapBeforeVisualisation = false;

    public BaseRuntimeException() {
        this.setMessage(null);
        this.autolog();
    }

    public BaseRuntimeException(Throwable rootCause) {
        this.setRootCause(rootCause);
        if (rootCause instanceof IBaseException) {
            this.setBabelMessage(((IBaseException)((Object)rootCause)).getBabelMessage());
            this.setAssistanceMessage(((IBaseException)((Object)rootCause)).getAssistanceMessage());
            this.setSeverity(((IBaseException)((Object)rootCause)).getSeverity());
        } else {
            this.setMessage(rootCause.getMessage());
        }
        this.autolog();
    }

    public BaseRuntimeException(String msg) {
        this.setMessage(msg);
        this.autolog();
    }

    public BaseRuntimeException(String msg, Throwable rootCause) {
        this.setMessage(msg);
        this.setRootCause(rootCause);
        if (rootCause != null && rootCause instanceof IBaseException) {
            this.setSeverity(((IBaseException)((Object)rootCause)).getSeverity());
        }
        this.autolog();
    }

    public BaseRuntimeException(BabelMessage babelMessage) {
        this.setBabelMessage(babelMessage);
        this.autolog();
    }

    public BaseRuntimeException(BabelMessage babelMessage, BabelMessage assistanceMessage) {
        this.setBabelMessage(babelMessage);
        this.setAssistanceMessage(assistanceMessage);
        this.autolog();
    }

    public BaseRuntimeException(BabelMessage babelMessage, Throwable rootCause) {
        this.setRootCause(rootCause);
        this.setBabelMessage(babelMessage);
        if (rootCause != null && rootCause instanceof IBaseException) {
            this.setSeverity(((IBaseException)((Object)rootCause)).getSeverity());
        }
        this.autolog();
    }

    protected void autolog() {
        BaseException.autolog(this);
    }

    protected static void autolog(Throwable exception) {
        try {
            Throwable iBaseExceptionRootcause;
            if (!INITIALIZED_AUTOLOG) {
                Logger.getLogger("AutoLog").setUseParentHandlers(false);
                INITIALIZED_AUTOLOG = true;
            }
            if (exception instanceof IBaseException && (iBaseExceptionRootcause = ((IBaseException)((Object)exception)).getRootCause()) != null && !(iBaseExceptionRootcause instanceof IBaseException)) {
                Logger rootcauseLogger = Logger.getLogger("AutoLog.created." + iBaseExceptionRootcause.getClass().getName().toString());
                rootcauseLogger.log(Level.DEBUG, iBaseExceptionRootcause.getMessage());
                rootcauseLogger.log(Level.FINE, BaseRuntimeException.getStackTrace(iBaseExceptionRootcause));
            }
            Logger logger = Logger.getLogger("AutoLog.created." + exception.getClass().toString());
            if (exception instanceof IBaseException) {
                logger.log(Level.DEBUG, ((IBaseException)((Object)exception)).getBabelMessage());
            } else {
                logger.log(Level.DEBUG, exception.getMessage());
            }
            logger.log(Level.FINE, BaseRuntimeException.getStackTrace(exception));
        }
        catch (Exception e) {
            Logger logger = Logger.getLogger(exception.getClass().toString());
            logger.error("The auto logging of the BaseRuntimeException " + exception.getClass().toString() + " failed.", e);
        }
    }

    public Level getSeverity() {
        return this.severity;
    }

    public void setSeverity(Level level) {
        if (level != null && (level.equals(Level.INFO) || level.equals(Level.WARNING) || level.equals(Level.ERROR) || level.equals(Level.FATAL))) {
            this.severity = level;
        }
    }

    public void setWrapBeforeVisualisation(boolean wrapBeforeVisualisation) {
        this.wrapBeforeVisualisation = wrapBeforeVisualisation;
    }

    public boolean getWrapBeforeVisualisation() {
        return this.wrapBeforeVisualisation;
    }

    public String getErrorCode() {
        return this.message.getMessageId();
    }

    public void setRootCause(Throwable rootCause) {
        this.rootCause = rootCause;
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public void setBabelMessage(BabelMessage bm) {
        if (bm != null) {
            this.message = bm;
        } else {
            this.setMessage(null);
        }
    }

    public BabelMessage getBabelMessage() {
        return this.message;
    }

    public void setAssistanceMessage(Message am) {
        this.assistance = am;
    }

    public Message getAssistanceMessage() {
        return this.assistance;
    }

    public void setMessage(String text) {
        this.message = BabelMessage.createFromString(text);
        this.message.setMessageId(this.getClass().getName().toString());
    }

    public String getMessage() {
        return this.getMessage(null);
    }

    public String getMessage(Locale loc) {
        return this.message.toString(loc);
    }

    public void finallyLocalize(Locale loc) {
        this.message.finallyLocalize(loc);
        if (this.getRootCause() instanceof IBaseException) {
            ((IBaseException)((Object)this.getRootCause())).finallyLocalize(loc);
        }
    }

    private static String getStackTrace(Throwable e) {
        if (e == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

