/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.misc.api;

import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.misc.api.Util;
import com.sap.aii.util.prop.api.PropertySource;
import com.sap.aii.util.prop.api.PropertySourceFactory;
import com.sap.aii.util.prop.api.PropertyTools;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class AIIProperties {
    private static final Logger log = Logger.getLogger((class$com$sap$aii$util$misc$api$AIIProperties == null ? (class$com$sap$aii$util$misc$api$AIIProperties = AIIProperties.class$("com.sap.aii.util.misc.api.AIIProperties")) : class$com$sap$aii$util$misc$api$AIIProperties).getName());
    private static final String AII_PROP_FILE = "aii.properties";
    public static final String AII_PROP_ROOT = "com.sap.aii.";
    public static final String JNLP_PREFIX = "jnlp.properties.";
    public static final String DB_DRIVER = "com.sap.aii.util.sql.driver";
    public static final String DB_PROTOCOL = "com.sap.aii.util.sql.protocol";
    public static final String DB_HOST = "com.sap.aii.util.sql.host";
    public static final String DB_NAME = "com.sap.aii.util.sql.name";
    public static final String DB_USER = "com.sap.aii.util.sql.user";
    public static final String DB_PASSWORD = "com.sap.aii.util.sql.password";
    public static final String DB_UNICODE = "com.sap.aii.util.sql.unicode";
    public static final String DB_SINGLEUSER = "com.sap.aii.util.sql.singleUser";
    public static final String DB_TIMEOUT = "com.sap.aii.util.sql.timeout";
    public static final String DB_TRACE = "com.sap.aii.util.sql.trace";
    public static final String DB_TRACE_FILENAME = "com.sap.aii.util.sql.trace.filename";
    public static final String DB_LOGLEVEL = "com.sap.aii.util.sql.loglevel";
    public static final String DB_STMT_CACHE_OFF = "com.sap.aii.util.sql.stmtCacheOff";
    public static final String DB_OPEN_LEVEL = "com.sap.aii.util.sql.openLevel";
    public static final String XML_PARSERFACTORY = "com.sap.aii.util.xml.parserFactory";
    public static final String XML_TRANSFORMERFACTORY = "com.sap.aii.util.xml.transformerFactory";
    public static final String XML_SCHEMA_VALIDATOR = "com.sap.aii.util.xml.schemaValidator";
    public static final String GUID_FACTORY_IMPL = "com.sap.aii.util.guid.guidGenerator";
    public static final String SERVER_NAME_DIRECTORY = "com.sap.aii.connect.directory.name";
    public static final String SERVER_PORT_DIRECTORY = "com.sap.aii.connect.directory.rmiport";
    public static final String SERVER_HTTPPORT_DIRECTORY = "com.sap.aii.connect.directory.httpport";
    public static final String SERVER_ROOT_DIRECTORY = "com.sap.aii.connect.directory.contextroot";
    public static final String SERVER_NAME_REPOSITORY = "com.sap.aii.connect.repository.name";
    public static final String SERVER_PORT_REPOSITORY = "com.sap.aii.connect.repository.rmiport";
    public static final String SERVER_HTTPPORT_REPOSITORY = "com.sap.aii.connect.repository.httpport";
    public static final String SERVER_ROOT_REPOSITORY = "com.sap.aii.connect.repository.contextroot";
    public static final String INTEGRATION_SERVER_HOSTNAME = "com.sap.aii.connect.integrationserver.name";
    public static final String INTEGRATION_SERVER_HTTPPORT = "com.sap.aii.connect.integrationserver.httpport";
    public static final String INTEGRATION_SERVER_CONTEXTROOT = "com.sap.aii.connect.integrationserver.contextroot";
    public static final String INTEGRATION_SERVER_R3_CLIENT = "com.sap.aii.connect.integrationserver.r3.client";
    public static final String INTEGRATION_SERVER_R3_SYSNR = "com.sap.aii.connect.integrationserver.r3.sysnr";
    public static final String INTEGRATION_SERVER_R3_HTTPPORT = "com.sap.aii.connect.integrationserver.r3.httpport";
    public static final String CR_HOSTNAME = "com.sap.aii.connect.cr.name";
    public static final String CR_HTTPPORT = "com.sap.aii.connect.cr.httpport";
    public static final String CR_CONTEXTROOT = "com.sap.aii.connect.cr.contextroot";
    public static final String RWB_HOSTNAME = "com.sap.aii.connect.rwb.name";
    public static final String RWB_HTTPPORT = "com.sap.aii.connect.rwb.httpport";
    public static final String RWB_CONTEXTROOT = "com.sap.aii.connect.rwb.contextroot";
    public static final String LANDSCAPE_HOSTNAME = "com.sap.aii.connect.landscape.name";
    public static final String LANDSCAPE_HTTPPORT = "com.sap.aii.connect.landscape.httpport";
    public static final String LANDSCAPE_CONTEXTROOT = "com.sap.aii.connect.landscape.contextroot";
    public static final String PERFORMANCE_TEST = "com.sap.aii.ib.client.enablePerf";
    public static final String LOGIN_LANGUAGES = "com.sap.aii.ib.client.login.languages";
    public static final String INITIALCONTEXTFACTORY = "com.sap.aii.ib.client.login.InitialContextFactory";
    public static final String ENABLE_XI_10_IMPORT = "com.sap.aii.ib.client.enableImport";
    public static final String APPLICATIONNAME_DIRECTORY = "com.sap.aii.ib.client.applicationname.directory";
    public static final String APPLICATIONNAME_REPOSITORY = "com.sap.aii.ib.client.applicationname.repository";
    public static final String APPLICATIONNAME_RUNTIME = "com.sap.aii.ib.client.applicationname.runtime";
    public static final String SERVICEUSER_NAME_DIR = "com.sap.aii.directory.serviceuser.name";
    public static final String SERVICEUSER_PWD_DIR = "com.sap.aii.directory.serviceuser.pwd";
    public static final String SERVICEUSER_LANG_DIR = "com.sap.aii.directory.serviceuser.language";
    public static final String SERVICEUSER_NAME_REP = "com.sap.aii.repository.serviceuser.name";
    public static final String SERVICEUSER_PWD_REP = "com.sap.aii.repository.serviceuser.pwd";
    public static final String SERVICEUSER_LANG_REP = "com.sap.aii.repository.serviceuser.language";
    public static final String SERVICEUSER_NAME_RWB = "com.sap.aii.rwb.serviceuser.name";
    public static final String SERVICEUSER_PWD_RWB = "com.sap.aii.rwb.serviceuser.pwd";
    public static final String SERVICEUSER_LANG_RWB = "com.sap.aii.rwb.serviceuser.language";
    public static final String SERVER_LOCKAUTH_ACTIVATION = "com.sap.aii.ib.server.lockauth.activation";
    public static final String SERVER_PVC_LOCK_ACTIVATION = "com.sap.aii.ib.server.pvc.locking";
    public static final String SERVER_R3_USE_FAST_RFC = "com.sap.aii.ib.server.connect.webas.r3.usefastrfc";
    public static final String SERVER_R3_ASHOST = "com.sap.aii.ib.server.connect.webas.r3.ashost";
    public static final String SERVER_R3_SYSNR = "com.sap.aii.ib.server.connect.webas.r3.sysnr";
    public static final String SERVER_R3_CLIENT = "com.sap.aii.ib.server.connect.webas.r3.client";
    public static final String COMPILER_OPTIONS = "com.sap.aii.ibrep.server.compiler.options";
    public static final String MAPPING_ADD_TYPES = "com.sap.aii.repository.mapping.additionaltypes";
    public static final String ANONYMIZED_NAME = "com.sap.aii.ib.server.anonymizedUser";
    public static final String JNLP_J2SE_VERSION = "com.sap.aii.ib.client.jnlp.j2se.version";
    public static final String JNLP_J2SE_INITIAL_HEAPSIZE = "com.sap.aii.ib.client.jnlp.j2se.initialheapsize";
    public static final String JNLP_J2SE_MAX_HEAPSIZE = "com.sap.aii.ib.client.jnlp.j2se.maxheapsize";
    public static final int PROPERTY_UNKNOWN = 0;
    public static final int PROPERTY_DIRECT = 500;
    private static AIIProperties instance = new AIIProperties();
    private transient PropertyChangeSupport pcsupport = new PropertyChangeSupport(this);
    private PropertySource source;
    static /* synthetic */ Class class$com$sap$aii$util$misc$api$AIIProperties;

    private AIIProperties() {
        this.sync();
        StringBuffer sb = new StringBuffer("Initial AIIProperties\n");
        Enumeration e = Util.sort(this.propertyNames(), null);
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = this.getProperty(name, false);
            if (AIIProperties.isConfidential(name)) {
                value = "XXXXXXXX";
            }
            sb.append("\t").append(name).append(" = ").append(value).append("\n");
        }
        log.debug(sb.toString());
    }

    public static boolean isConfidential(String name) {
        return name.endsWith("password") || name.endsWith("pwd") || name.endsWith("credentials");
    }

    public static AIIProperties getInstance() {
        return instance;
    }

    public int testProperty(String key) {
        key = this.getPrefixedName(key);
        String value = this.source.getPropertySet().getProperty(key);
        if (value != null) {
            return 500;
        }
        return 0;
    }

    private String getProperty(String key, boolean logIt) {
        key = this.getPrefixedName(key);
        String value = this.source.getPropertySet().getProperty(key);
        if (value == null && logIt) {
            log.info("AIIProperty " + key + " not found");
        }
        return value;
    }

    public String getProperty(String key) {
        return this.getProperty(key, true);
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key, false);
        return value != null ? value : defaultValue;
    }

    public void setProperty(String key, String value) {
        key = this.getPrefixedName(key);
        String oldValue = this.source.getPropertySet().getProperty(key);
        this.source.getPropertySet().setProperty(key, value);
        if (!value.equals(oldValue)) {
            this.firePropertyChange(key, oldValue, value);
        }
    }

    private String getPrefixedName(String name) {
        return name.startsWith(AII_PROP_ROOT) ? name : AII_PROP_ROOT + name;
    }

    public Enumeration propertyNames() {
        String[] names = this.source.getPropertySet().getPropertyNames();
        List<String> list = Arrays.asList(names);
        return Collections.enumeration(list);
    }

    public void sync() {
        String newValue;
        String oldValue;
        String name;
        this.source = PropertySourceFactory.getPropertySource();
        Properties oldProp = PropertyTools.exportProperties(this.source.getPropertySet(), "", "");
        this.source.sync();
        Properties newProp = PropertyTools.exportProperties(this.source.getPropertySet(), "", "");
        Enumeration<?> e = oldProp.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            oldValue = oldProp.getProperty(name);
            if (oldValue.equals(newValue = newProp.getProperty(name))) continue;
            this.firePropertyChange(name, oldValue, newValue);
        }
        e = newProp.propertyNames();
        while (e.hasMoreElements()) {
            name = (String)e.nextElement();
            oldValue = oldProp.getProperty(name);
            if (oldValue != null) continue;
            newValue = newProp.getProperty(name);
            this.firePropertyChange(name, oldValue, newValue);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcsupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.pcsupport.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcsupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.pcsupport.removePropertyChangeListener(name, listener);
    }

    protected void firePropertyChange(String name, String oldValue, String newValue) {
        this.pcsupport.firePropertyChange(name, oldValue, newValue);
    }

    public static void main(String[] args) throws Exception {
        AIIProperties p = AIIProperties.getInstance();
        p.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pe) {
                System.out.println(">>> AIIProperty \"" + pe.getPropertyName() + "\" changed from " + pe.getOldValue() + " to " + pe.getNewValue());
            }
        });
        String name = "util.sql.name";
        System.out.println(name + "=" + p.getProperty(name));
        p.setProperty(name, "xyz");
        System.out.println("xcf = " + p.testProperty("xcf"));
        System.out.println("util.sql.name = " + p.testProperty("util.sql.name"));
        System.out.println("util.sql.trace = " + p.testProperty("util.sql.trace"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

