/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.servlet;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.LogManager;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.log.impl.AIILogFactoryImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;

public class Tool {
    private static AIILogFactoryImpl logFactory = AIILogFactoryImpl.getInstance();

    public static boolean checkLoggingImpl(Writer out) {
        String implName = LogManager.getLogFactory().getImplementationName();
        if (!implName.equals("AII Logging")) {
            if (out != null) {
                try {
                    out.write("<div style=\"background-color:#c00000; color:white\">");
                    out.write("<b>WARNING: \"" + implName + "\" is used as Logging implementation, but this page only supports AIILogging.</b>");
                    out.write("</div>");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    public static String getStringParam(HttpServletRequest request, String name) {
        String s = request.getParameter(name);
        return s == null ? "" : s;
    }

    public static int getIntParam(HttpServletRequest request, String name) {
        String s = request.getParameter(name);
        if (s == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public static void writeHTMLHeader(PrintWriter out, String title) {
        out.println("<html>");
        out.println("<head><title>" + title + "</title></head>");
        out.println("<body>");
        out.println("<h2>" + title + "</h2>");
    }

    public static void writeHTMLFooter(PrintWriter out) {
        out.println("</body></html>");
    }

    public static void writeLevelSelect(PrintWriter out, String field, String selected) {
        out.println("<select name=\"" + field + "\" size=1>");
        Object[] levels = Level.getAllLevels();
        Arrays.sort(levels);
        int i = 0;
        while (i < levels.length) {
            String name = ((Level)levels[i]).getName();
            out.print("<option");
            if (name.equals(selected)) {
                out.print(" selected");
            }
            out.println(" value=\"" + name + "\">" + name + "</option>");
            ++i;
        }
        out.println("</select>");
    }

    public static void writeLoggerSelect(PrintWriter out, String field, String selected) {
        out.println("<select name=\"" + field + "\" size=1>");
        Logger[] loggers = logFactory.getAllLoggers();
        Arrays.sort(loggers, new Logger.NameComparator());
        int i = 0;
        while (i < loggers.length) {
            String name = loggers[i].getName();
            out.print("<option");
            if (name.equals(selected)) {
                out.print(" selected");
            }
            out.println(" value=\"" + name + "\">" + name + "</option>");
            ++i;
        }
        out.println("</select>");
    }
}

