/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.servlet;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.log.impl.AIILogFactoryImpl;
import com.sap.aii.util.log.impl.Filter;
import com.sap.aii.util.log.impl.Handler;
import com.sap.aii.util.log.impl.InvertFilter;
import com.sap.aii.util.log.impl.MemLogHandler;
import com.sap.aii.util.log.impl.MultiFilter;
import com.sap.aii.util.log.impl.SimpleFilter;
import com.sap.aii.util.log.servlet.Tool;
import com.sap.aii.util.misc.api.StringUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ShowMemLog
extends HttpServlet {
    private static final String version = "v3.4";
    private static final String CONTENT_TYPE = "text/html";
    private static final String CLEAR = "Clear LOG";
    private static final String SET_SIZE = "Set Size";
    private static final String DISPLAY = "Show this Filter";
    private static final String DISPLAY_MULTI = "Show multiple Filters";
    private static final String ADD = "Add Filter >";
    private static final String REMOVE = "< Remove Filter";
    private static final String INVERT = "invert";
    private String logThread;
    private String logClass;
    private String logLevel;
    private MultiFilter multiFilter;
    private Filter invFilter;
    private Map filterMap;
    private int filterCount;
    private boolean invert;
    private static AIILogFactoryImpl logFactory = AIILogFactoryImpl.getInstance();

    private void setInitialValues() {
        this.logThread = "";
        this.logClass = logFactory.getRootLogger().getName();
        this.logLevel = "ALL";
        this.multiFilter = new MultiFilter();
        this.invFilter = new InvertFilter(this.multiFilter);
        this.filterMap = new HashMap();
        this.filterCount = 0;
        this.invert = false;
    }

    private void storeAttributes(HttpSession ses) {
        ses.setAttribute("logTread", (Object)this.logThread);
        ses.setAttribute("logClass", (Object)this.logClass);
        ses.setAttribute("logLevel", (Object)this.logLevel);
        ses.setAttribute("multiFilter", (Object)this.multiFilter);
        ses.setAttribute("invFilter", (Object)this.invFilter);
        ses.setAttribute("filterMap", (Object)this.filterMap);
        ses.setAttribute("filterCount", (Object)new Integer(this.filterCount));
        ses.setAttribute(INVERT, (Object)new Boolean(this.invert));
        ses.setAttribute("isInitialized", (Object)Boolean.TRUE);
    }

    private void loadAttributes(HttpSession ses) {
        if (ses.getAttribute("isInitialized") != null) {
            this.logThread = (String)ses.getAttribute("logTread");
            this.logClass = (String)ses.getAttribute("logClass");
            this.logLevel = (String)ses.getAttribute("logLevel");
            this.multiFilter = (MultiFilter)ses.getAttribute("multiFilter");
            this.invFilter = (Filter)ses.getAttribute("invFilter");
            this.filterMap = (Map)ses.getAttribute("filterMap");
            this.filterCount = (Integer)ses.getAttribute("filterCount");
            this.invert = (Boolean)ses.getAttribute(INVERT);
        } else {
            this.setInitialValues();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    private void writeHTML(PrintWriter out, MemLogHandler mh, Filter filter) {
        Tool.writeHTMLHeader(out, "Show MemLog");
        Tool.checkLoggingImpl(out);
        out.println("Links: <a href=\"./ControlLog\">Logging Control</a>");
        out.println("<hr>");
        if (mh == null) {
            out.println("Handler \"RootMemLog\" not found...");
        } else {
            out.println("<form action=\"./ShowMemLog\" method=post>");
            out.println("<input type=submit name=action value=\"Clear LOG\" />");
            out.println("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            out.println("<input name=\"size\" align=right maxlength=4 value=\"" + mh.getSize() + "\"/>");
            out.println("<input type=submit name=action value=\"Set Size\" />");
            out.println("<hr>");
            out.println("<table cellpadding=6 >");
            out.println("<tr><td align=center>");
            out.println("<table>");
            out.println("<tr><td align=right>Thread:</td><td><input name=\"thread\" value=\"" + this.logThread + "\"/></td></tr>");
            out.println("<tr><td align=right>OutputLevel:</td> <td>");
            Tool.writeLevelSelect(out, "level", this.logLevel);
            out.println("</td></tr>");
            out.println("<tr><td align=right>Log Category:</td><td>");
            Tool.writeLoggerSelect(out, "class", this.logClass);
            out.println("</td></tr>");
            out.println("</table>");
            out.println("</td><td align=center>");
            out.println("<input type=submit name=action value=\"Add Filter >\" /><br>");
            out.println("<input type=submit name=action value=\"< Remove Filter\" />");
            out.println("</td><td align=center>");
            out.println("Filters (OR)<br>");
            out.println("<select name=\"filter\" size=4>");
            Iterator i = this.filterMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                out.println("<option value=\"" + key + "\">" + ((Filter)this.filterMap.get(key)).toString() + "</option>");
            }
            out.println("</select><br>");
            out.println("<input type=checkbox name=\"invert\" value=\"true\"");
            if (this.invert) {
                out.println(" checked");
            }
            out.println(">Invert Selection</input>");
            out.println("</td></tr>");
            out.println("<tr> <td align=center>");
            out.println("<input type=submit name=action value=\"Show this Filter\" />");
            out.println("</td><td align=center>");
            out.println("</td><td align=center>");
            out.println("<input type=submit name=action value=\"Show multiple Filters\" />");
            out.println("</td></tr>");
            out.println("</table>");
            out.println("</form>");
            out.println("<hr>");
            if (filter != null) {
                out.println("<pre>");
                Enumeration e = mh.getLogMessages(filter);
                while (e.hasMoreElements()) {
                    out.println(StringUtil.escapeXMLChars((String)e.nextElement()));
                }
                out.println("</pre>");
            }
        }
        out.println("<hr><p style=\"font-size:80%\" align=right>v3.4</p>");
        Tool.writeHTMLFooter(out);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        this.loadAttributes(request.getSession());
        MemLogHandler mh = (MemLogHandler)Handler.getHandler("RootMemLog");
        this.writeHTML(out, mh, null);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.loadAttributes(request.getSession());
        String action = Tool.getStringParam(request, "action");
        this.logThread = Tool.getStringParam(request, "thread");
        this.logClass = Tool.getStringParam(request, "class");
        Logger log = logFactory.getLogger(this.logClass);
        this.logLevel = Tool.getStringParam(request, "level");
        Level level = Level.getLevel(this.logLevel);
        if (level == null) {
            level = Level.DEFAULT;
        }
        this.invert = Boolean.valueOf(Tool.getStringParam(request, INVERT));
        Filter myFilter = this.invert ? this.invFilter : this.multiFilter;
        MemLogHandler mh = (MemLogHandler)Handler.getHandler("RootMemLog");
        if (action.equals(CLEAR)) {
            if (mh != null) {
                mh.clear();
            }
        } else if (action.equals(SET_SIZE)) {
            if (mh != null) {
                int size = Tool.getIntParam(request, "size");
                if (size < 1) {
                    size = 100;
                }
                mh.setSize(size);
            }
        } else if (action.equals(ADD)) {
            String tn = this.logThread.length() > 0 ? this.logThread : null;
            SimpleFilter f = new SimpleFilter(log, level, tn);
            this.filterMap.put(Integer.toString(this.filterCount++), f);
            this.multiFilter.addFilter(f);
        } else if (action.equals(REMOVE)) {
            Filter f;
            String key = Tool.getStringParam(request, "filter");
            if (key.length() > 0 && (f = (Filter)this.filterMap.remove(key)) != null) {
                this.multiFilter.removeFilter(f);
            }
        } else if (action.equals(DISPLAY)) {
            String tn = this.logThread.length() > 0 ? this.logThread : null;
            myFilter = new SimpleFilter(log, level, tn);
        }
        response.setContentType(CONTENT_TYPE);
        PrintWriter out = response.getWriter();
        this.writeHTML(out, mh, myFilter);
        this.storeAttributes(request.getSession());
    }

    public void destroy() {
    }
}

