/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.impl;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.Logger;
import java.io.Serializable;
import java.util.Date;

public class LogRecord
implements Serializable {
    static final long serialVersionUID = -6093232185940407078L;
    private static long count = 0L;
    private String loggerName;
    private Level level;
    private String message;
    private long number;
    private String thread;
    private Date date;
    private Throwable thrown;
    private Logger logger = null;

    public LogRecord(String loggerName, Level level, String message) {
        this.loggerName = loggerName;
        this.level = level;
        this.message = message;
        this.number = count++;
        this.thread = Thread.currentThread().getName();
        this.date = new Date();
        this.thrown = null;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.loggerName);
        }
        return this.logger;
    }

    public long getSequenceNumber() {
        return this.number;
    }

    public String getThreadName() {
        return this.thread;
    }

    public Date getDate() {
        return this.date;
    }

    public long getMillis() {
        return this.date.getTime();
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable t) {
        this.thrown = t;
    }
}

