/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.log.impl;

import com.sap.aii.util.log.api.Level;
import com.sap.aii.util.log.api.NameMap;
import com.sap.aii.util.log.impl.DefaultFormatter;
import com.sap.aii.util.log.impl.Formatter;
import com.sap.aii.util.log.impl.LogRecord;
import java.util.Comparator;

public abstract class Handler {
    private static final NameMap handlers = new NameMap();
    private Level level;
    protected String name;
    protected Formatter formatter = new DefaultFormatter();

    protected Handler(String name) {
        if (name != null) {
            if (handlers.containsKey(name)) {
                handlers.remove(name);
            }
            handlers.put(name, "Handler", this);
        }
        this.level = null;
        this.name = name;
    }

    public static Handler getHandler(String name) {
        return (Handler)handlers.get(name);
    }

    public void publish(LogRecord rec) {
        if (this.isLoggable(rec)) {
            this.publish(this.formatter.format(rec));
        }
    }

    public boolean isLoggable(LogRecord rec) {
        return this.level == null || rec.getLevel().getPriority() >= this.level.getPriority();
    }

    public abstract void publish(String var1);

    public abstract void close();

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public String getName() {
        return this.name;
    }

    public static Handler[] getAllHandlers() {
        return handlers.values().toArray(new Handler[0]);
    }

    public static class NameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            return ((Handler)o1).getName().compareTo(((Handler)o2).getName());
        }

        public boolean equals(Object o1, Object o2) throws ClassCastException {
            return ((Handler)o1).getName().equals(((Handler)o2).getName());
        }
    }
}

